/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.server;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.setbonus.SetBonusData;
import com.fantasticsource.setbonus.common.Bonus;
import com.fantasticsource.setbonus.common.Network;
import com.fantasticsource.setbonus.common.bonuselements.ABonusElement;
import com.fantasticsource.setbonus.common.bonusrequirements.ABonusRequirement;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerBonus
extends Bonus {
    public static boolean changed;
    public static boolean save;
    private LinkedHashMap<EntityPlayer, BonusInstance> instances = new LinkedHashMap();

    public static void dropAll() {
        for (Bonus bonus : SetBonusData.SERVER_DATA.bonuses) {
            for (BonusInstance data : ((ServerBonus)bonus).instances.values()) {
                data.update(false);
            }
        }
        SetBonusData.SERVER_DATA.bonuses.clear();
    }

    public static void updateBonuses(EntityPlayerMP player, boolean forceNew) {
        changed = false;
        save = false;
        for (Bonus bonus : SetBonusData.SERVER_DATA.bonuses) {
            ((ServerBonus)bonus).update(player, forceNew);
        }
        while (changed) {
            changed = false;
            for (Bonus bonus : SetBonusData.SERVER_DATA.bonuses) {
                ((ServerBonus)bonus).update(player, false);
            }
        }
        if (save) {
            ServerBonus.saveDiscoveries(player);
        }
    }

    public void update(EntityPlayerMP player, boolean forceNew) {
        if (forceNew) {
            BonusInstance instance = new BonusInstance(player, this);
            this.instances.put((EntityPlayer)player, instance);
            instance.update();
        } else {
            this.instances.computeIfAbsent((EntityPlayer)player, k -> new BonusInstance(player, this)).update();
        }
    }

    @Nonnull
    public BonusInstance getBonusInstance(EntityPlayerMP player) {
        return this.instances.computeIfAbsent((EntityPlayer)player, k -> new BonusInstance(player, this));
    }

    public static void saveDiscoveries(EntityPlayerMP player) {
        World world = player.field_70170_p;
        try {
            String string = MCTools.getDataDir((MinecraftServer)world.func_73046_m()) + "setbonus" + File.separator;
            File file = new File(string);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(file = new File(string = string + "discoveries" + File.separator)).exists()) {
                file.mkdir();
            }
            string = string + player.func_189512_bd() + ".txt";
            file = new File(string);
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            for (Bonus bonus : SetBonusData.SERVER_DATA.bonuses) {
                BonusInstance data = ((ServerBonus)bonus).instances.get(player);
                if (data == null || !data.discovered) continue;
                writer.write(bonus.id + "\r\n");
            }
            writer.close();
        }
        catch (IOException e) {
            MCTools.crash((Exception)e, (int)901, (boolean)false);
        }
    }

    public static void loadDiscoveries(EntityPlayerMP player) {
        World world = player.field_70170_p;
        try {
            String string = MCTools.getDataDir((MinecraftServer)world.func_73046_m()) + "setbonus" + File.separator;
            File file = new File(string);
            if (!file.exists()) {
                return;
            }
            file = new File(string = string + "discoveries" + File.separator);
            if (!file.exists()) {
                return;
            }
            file = new File(string = string + player.func_189512_bd() + ".txt");
            if (!file.exists()) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            string = reader.readLine();
            while (string != null && !string.equals("")) {
                Bonus bonus = null;
                for (Bonus bonus2 : SetBonusData.SERVER_DATA.bonuses) {
                    if (!bonus2.id.equals(string)) continue;
                    bonus = bonus2;
                    break;
                }
                if (bonus != null && bonus.discoveryMode != 2) {
                    ((ServerBonus)bonus).getBonusInstance((EntityPlayerMP)player).discovered = true;
                }
                string = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            MCTools.crash((Exception)e, (int)901, (boolean)false);
        }
        ServerBonus.saveDiscoveries(player);
    }

    public static void clearMem(EntityPlayer player) {
        for (Bonus bonus : SetBonusData.SERVER_DATA.bonuses) {
            BonusInstance data = ((ServerBonus)bonus).instances.get(player);
            if (data == null) continue;
            data.update(false);
            ((ServerBonus)bonus).instances.remove(player);
        }
    }

    public class BonusInstance {
        public boolean active;
        public boolean discovered;
        private EntityPlayerMP player;
        private ServerBonus bonus;

        private BonusInstance(EntityPlayerMP player, ServerBonus bonus) {
            this.player = player;
            this.bonus = bonus;
        }

        public BonusInstance update() {
            for (ABonusRequirement requirement : ServerBonus.this.requirements) {
                if (requirement.active((EntityPlayer)this.player) >= requirement.required()) continue;
                this.update(false);
                return this;
            }
            this.update(true);
            return this;
        }

        private void update(boolean activate) {
            block7: {
                block6: {
                    if (!activate) break block6;
                    if (!this.active) {
                        changed = true;
                        this.active = true;
                        if (this.bonus.discoveryMode == 0 && !this.discovered) {
                            this.discovered = true;
                            Network.WRAPPER.sendTo((IMessage)new Network.DiscoverBonusPacket(this.bonus), this.player);
                            save = true;
                        }
                        for (ABonusElement element : ServerBonus.this.bonusElements) {
                            element.activate((EntityPlayer)this.player);
                        }
                    } else {
                        for (ABonusElement element : ServerBonus.this.bonusElements) {
                            element.updateActive((EntityPlayer)this.player);
                        }
                    }
                    break block7;
                }
                if (!this.active) break block7;
                changed = true;
                this.active = false;
                for (ABonusElement element : ServerBonus.this.bonusElements) {
                    element.deactivate((EntityPlayer)this.player);
                }
            }
        }
    }
}

