/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common.bonusrequirements.setrequirement;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import com.fantasticsource.setbonus.SetBonusData;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.Equip;
import com.fantasticsource.tools.ReflectionTool;
import com.gildedgames.the_aether.api.AetherAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SlotData {
    public static final int BAUBLES_OFFSET = -2147483647;
    public static final int BAUBLES_THRESHOLD = -2147483347;
    public static final int AETHER_OFFSET = -2147483347;
    public static final int AETHER_THRESHOLD = -2147483339;
    public static final int TRINKETS_OFFSET = -2147483339;
    public static final int TRINKETS_THRESHOLD = -2147483307;
    public static final String[] VALID_SLOT_NAMES;
    public LinkedHashSet<String> slotNames = new LinkedHashSet();
    public LinkedHashSet<Equip> involvedEquips = new LinkedHashSet();

    private SlotData() {
    }

    public static SlotData getEmpty() {
        return new SlotData();
    }

    public static SlotData getInstance(String slotsAndEquipment, SetBonusData data) {
        SlotData result = new SlotData();
        String[] tokens = slotsAndEquipment.split("=");
        if (tokens.length != 2) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.wrongSlotArgCount", (Object[])new Object[]{slotsAndEquipment}));
            return null;
        }
        ArrayList<String> errors = SlotData.addSlotsFromString(tokens[0], result);
        if (errors.size() > 0) {
            for (String error : errors) {
                System.err.println(I18n.func_74837_a((String)"setbonus.error.unknownSlot", (Object[])new Object[]{error, slotsAndEquipment}));
            }
            return null;
        }
        for (String equipID : tokens[1].split("[|]")) {
            equipID = equipID.trim();
            Equip equip = null;
            for (Equip equip2 : data.equipment) {
                if (!equip2.id.equals(equipID)) continue;
                equip = equip2;
                break;
            }
            if (equip == null) {
                System.err.println(I18n.func_74837_a((String)"setbonus.error.slotBadEquipID", (Object[])new Object[]{equipID, slotsAndEquipment}));
                return null;
            }
            result.involvedEquips.add(equip);
        }
        return result;
    }

    public static ItemStack getStackInSlot(EntityPlayer player, int slot) {
        if (slot == -1) {
            slot = player.field_71071_by.field_70461_c;
        }
        if (slot > -1) {
            return player.field_71071_by.func_70301_a(slot);
        }
        if (slot < -2147483347) {
            return BaublesApi.getBaublesHandler(player).getStackInSlot(slot - -2147483647);
        }
        if (slot < -2147483339) {
            return AetherAPI.getInstance().get(player).getAccessoryInventory().func_70301_a(slot - -2147483347);
        }
        if (slot < -2147483307) {
            Class trinketHelperClass = ReflectionTool.getClassByName((String)"xzeroair.trinkets.api.TrinketHelper");
            IItemHandlerModifiable trinketContainerHandler = (IItemHandlerModifiable)ReflectionTool.invoke((Class)trinketHelperClass, (String)"getTrinketHandler", null, (Object[])new Object[]{player});
            return (slot += 2147483339) < trinketContainerHandler.getSlots() ? trinketContainerHandler.getStackInSlot(slot) : ItemStack.field_190927_a;
        }
        throw new IllegalArgumentException();
    }

    public int equipped(EntityPlayer player, ArrayList<Integer> blocked, boolean allowEmptyStackIfMatching, boolean allowStackableItems) {
        for (String slotName : this.slotNames) {
            for (int slot : SlotData.getSlotIDs(slotName)) {
                if (slot == -1) {
                    slot = player.field_71071_by.field_70461_c;
                }
                if (blocked != null && blocked.contains(slot)) continue;
                ItemStack stack = SlotData.getStackInSlot(player, slot);
                if (!allowEmptyStackIfMatching && stack == ItemStack.field_190927_a || !allowStackableItems && stack.func_77976_d() != 1) continue;
                for (Equip equip : this.involvedEquips) {
                    if (!equip.filter.matches(stack)) continue;
                    return slot;
                }
            }
        }
        return Integer.MIN_VALUE;
    }

    public static ArrayList<String> addSlotsFromString(String slots, SlotData slotData) {
        ArrayList<String> errors = new ArrayList<String>();
        for (String slotString : slots.split("[|]")) {
            ArrayList<Integer> slotIDs = SlotData.getSlotIDs(slotString);
            if (slotIDs == null) {
                errors.add(slotString.trim().toLowerCase());
                continue;
            }
            slotData.slotNames.add(slotString.trim());
        }
        return errors;
    }

    public static ArrayList<Integer> getSlotIDs(String slotString) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if ((slotString = slotString.trim().toLowerCase()).equals("mainhand")) {
            result.add(-1);
        } else if (slotString.equals("hotbar")) {
            for (int i = 0; i < 9; ++i) {
                result.add(i);
            }
        } else if (slotString.equals("inventory")) {
            for (int i = 9; i < 36; ++i) {
                result.add(i);
            }
        } else if (slotString.equals("feet")) {
            result.add(36);
        } else if (slotString.equals("legs")) {
            result.add(37);
        } else if (slotString.equals("chest")) {
            result.add(38);
        } else if (slotString.equals("head")) {
            result.add(39);
        } else if (slotString.equals("offhand")) {
            result.add(40);
        } else if (slotString.equals("bauble_amulet")) {
            for (int i : BaubleType.AMULET.getValidSlots()) {
                result.add(-2147483647 + i);
            }
        } else if (slotString.equals("bauble_ring")) {
            for (int i : BaubleType.RING.getValidSlots()) {
                result.add(-2147483647 + i);
            }
        } else if (slotString.equals("bauble_belt")) {
            for (int i : BaubleType.BELT.getValidSlots()) {
                result.add(-2147483647 + i);
            }
        } else if (slotString.equals("bauble_head")) {
            for (int i : BaubleType.HEAD.getValidSlots()) {
                result.add(-2147483647 + i);
            }
        } else if (slotString.equals("bauble_body")) {
            for (int i : BaubleType.BODY.getValidSlots()) {
                result.add(-2147483647 + i);
            }
        } else if (slotString.equals("bauble_charm")) {
            for (int i : BaubleType.CHARM.getValidSlots()) {
                result.add(-2147483647 + i);
            }
        } else if (slotString.equals("bauble_trinket")) {
            for (int i : BaubleType.TRINKET.getValidSlots()) {
                result.add(-2147483647 + i);
            }
        } else if (slotString.equals("aether_pendant")) {
            result.add(-2147483347);
        } else if (slotString.equals("aether_cape")) {
            result.add(-2147483346);
        } else if (slotString.equals("aether_shield")) {
            result.add(-2147483345);
        } else if (slotString.equals("aether_ring")) {
            result.add(-2147483343);
            result.add(-2147483342);
        } else if (slotString.equals("aether_glove") || slotString.equals("aether_gloves")) {
            result.add(-2147483341);
        } else if (slotString.equals("aether_other")) {
            result.add(-2147483344);
            result.add(-2147483340);
        } else if (slotString.equals("trinket")) {
            for (int i = -2147483339; i < -2147483307; ++i) {
                result.add(i);
            }
        } else {
            try {
                result.add(Integer.parseInt(slotString));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return result;
    }

    public SlotData clone(SetBonusData data) {
        SlotData other = new SlotData();
        other.slotNames.addAll(this.slotNames);
        block0: for (Equip equip : this.involvedEquips) {
            for (Equip equip2 : data.equipment) {
                if (!equip2.id.equals(equip.id)) continue;
                other.involvedEquips.add(equip2);
                continue block0;
            }
        }
        return other;
    }

    public String toString() {
        if (this.slotNames.size() == 0 || this.involvedEquips.size() == 0) {
            return "";
        }
        Iterator iterator = this.slotNames.iterator();
        String result = (String)iterator.next();
        while (iterator.hasNext()) {
            result = result + " | " + (String)iterator.next();
        }
        Iterator iterator2 = this.involvedEquips.iterator();
        result = result + " = " + ((Equip)iterator2.next()).id;
        while (iterator2.hasNext()) {
            result = result + " | " + ((Equip)iterator2.next()).id;
        }
        return result;
    }

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList("mainhand", "offhand", "head", "chest", "legs", "feet", "hotbar", "inventory", "bauble_amulet", "bauble_ring", "bauble_belt", "bauble_head", "bauble_body", "bauble_charm", "bauble_trinket", "aether_pendant", "aether_cape", "aether_shield", "aether_ring", "aether_glove", "aether_gloves", "aether_other", "trinket"));
        for (int i = 0; i <= 100; ++i) {
            list.add("" + i);
        }
        VALID_SLOT_NAMES = list.toArray(new String[0]);
    }
}

