/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common.bonusrequirements.setrequirement;

import com.fantasticsource.setbonus.SetBonusData;
import com.fantasticsource.setbonus.common.bonusrequirements.ABonusRequirement;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.Set;
import java.util.LinkedHashSet;
import net.minecraft.entity.player.EntityPlayer;

public class SetRequirement
extends ABonusRequirement {
    public Set set;
    public int num;

    public SetRequirement(Set set, int num) {
        this.set = set;
        this.num = num;
    }

    public static SetRequirement getInstance(String parseableSetRequirement, LinkedHashSet<Set> sets) throws Exception {
        String[] tokens2 = parseableSetRequirement.split("\\.");
        Set set = null;
        String id = tokens2[0].trim();
        for (Set set2 : sets) {
            if (!set2.id.equals(id)) continue;
            set = set2;
            break;
        }
        if (set == null) {
            return null;
        }
        if (tokens2.length == 1) {
            return new SetRequirement(set, -1);
        }
        int num = Integer.parseInt(tokens2[1].trim());
        if (num > 0) {
            return new SetRequirement(set, num);
        }
        throw new Exception();
    }

    @Override
    public int active(EntityPlayer player) {
        return this.set.getNumberEquipped(player);
    }

    @Override
    public int required() {
        return this.num == -1 ? this.set.slotData.size() : this.num;
    }

    @Override
    public SetRequirement clone(SetBonusData data) {
        for (Set set2 : data.sets) {
            if (!set2.id.equals(this.set.id)) continue;
            return new SetRequirement(set2, this.num);
        }
        throw new IllegalStateException("Failed to clone SetRequirement");
    }

    @Override
    public String toString() {
        return this.set.id + (this.num == -1 ? "" : "." + this.num);
    }
}

