/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common.bonuselements;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.attributes.AttributeMods;
import com.fantasticsource.setbonus.SetBonusData;
import com.fantasticsource.setbonus.common.Bonus;
import com.fantasticsource.setbonus.common.bonuselements.ABonusElement;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.translation.I18n;

public class BonusElementAttributeModifier
extends ABonusElement {
    public Multimap<String, AttributeModifier> modifiers = ArrayListMultimap.create();

    public BonusElementAttributeModifier() {
    }

    protected BonusElementAttributeModifier(Bonus bonus, ArrayList<AttributeModifier> modifiers) {
        super(bonus);
        for (AttributeModifier modifier : modifiers) {
            this.modifiers.put((Object)modifier.func_111166_b(), (Object)modifier.func_111168_a(false));
        }
    }

    public static BonusElementAttributeModifier getInstance(String parsableModifierBonus, SetBonusData data) {
        String[] tokens = parsableModifierBonus.split(",");
        if (tokens.length < 2) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.notEnoughAttribBonusArgs", (Object[])new Object[]{parsableModifierBonus}));
            return null;
        }
        String id = tokens[0].trim();
        Bonus bonus = null;
        for (Bonus bonus2 : data.bonuses) {
            if (!bonus2.id.equals(id)) continue;
            bonus = bonus2;
            break;
        }
        if (bonus == null) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.attribBonusIDNotFound", (Object[])new Object[]{tokens[0].trim(), parsableModifierBonus}));
            return null;
        }
        ArrayList modifiers = AttributeMods.parseMods((String[])Arrays.copyOfRange(tokens, 1, tokens.length));
        if (modifiers == null) {
            return null;
        }
        return new BonusElementAttributeModifier(bonus, modifiers);
    }

    @Override
    public void activate(EntityPlayer player) {
        float hpRatio = player.func_110143_aJ() / player.func_110138_aP();
        player.func_110140_aT().func_111147_b(this.modifiers);
        if (hpRatio <= Float.MIN_VALUE) {
            hpRatio = 0.0f;
        } else if (hpRatio >= 1.0f) {
            hpRatio = 1.0f;
        }
        player.func_70606_j(hpRatio * player.func_110138_aP());
    }

    @Override
    public void deactivate(EntityPlayer player) {
        float hpRatio = player.func_110143_aJ() / player.func_110138_aP();
        player.func_110140_aT().func_111148_a(this.modifiers);
        if (hpRatio <= Float.MIN_VALUE) {
            hpRatio = 0.0f;
        } else if (hpRatio >= 1.0f) {
            hpRatio = 1.0f;
        }
        player.func_70606_j(hpRatio * player.func_110138_aP());
    }

    @Override
    public void updateActive(EntityPlayer player) {
    }

    @Override
    public String[] tooltips() {
        String[] result = new String[this.modifiers.size()];
        int i = 0;
        for (AttributeModifier modifier : this.modifiers.values()) {
            result[i++] = MCTools.getAttributeModString((AttributeModifier)modifier);
        }
        return result;
    }

    public BonusElementAttributeModifier clone() {
        BonusElementAttributeModifier other = new BonusElementAttributeModifier();
        for (Map.Entry entry : this.modifiers.entries()) {
            AttributeModifier modifier = (AttributeModifier)entry.getValue();
            other.modifiers.put(entry.getKey(), (Object)new AttributeModifier(modifier.func_111166_b(), modifier.func_111164_d(), modifier.func_111169_c()));
        }
        return other;
    }

    @Override
    public BonusElementAttributeModifier clone(SetBonusData data) {
        return BonusElementAttributeModifier.getInstance(this.toString(), data);
    }

    @Override
    public String toString() {
        String result = this.bonus.id;
        for (Map.Entry entry : this.modifiers.entries()) {
            result = result + ", " + ((AttributeModifier)entry.getValue()).func_111166_b() + " = " + ((AttributeModifier)entry.getValue()).func_111164_d();
            int mode = ((AttributeModifier)entry.getValue()).func_111169_c();
            if (mode == 0) continue;
            result = result + " @ " + mode;
        }
        return result;
    }
}

