/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.client.gui;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.mctools.gui.element.other.GUIDarkenedBackground;
import com.fantasticsource.mctools.gui.element.other.GUILine;
import com.fantasticsource.mctools.gui.element.other.GUIVerticalScrollbar;
import com.fantasticsource.mctools.gui.element.text.GUINavbar;
import com.fantasticsource.mctools.gui.element.text.GUITextLabel;
import com.fantasticsource.mctools.gui.element.text.GUITextSpacer;
import com.fantasticsource.mctools.gui.element.view.GUIScrollView;
import com.fantasticsource.mctools.gui.element.view.GUIView;
import com.fantasticsource.mctools.gui.screen.MessageGUI;
import com.fantasticsource.mctools.gui.screen.YesNoGUI;
import com.fantasticsource.setbonus.SetBonusData;
import com.fantasticsource.setbonus.client.gui.bonus.GUIBonus;
import com.fantasticsource.setbonus.client.gui.equip.GUIEquip;
import com.fantasticsource.setbonus.client.gui.set.GUISet;
import com.fantasticsource.setbonus.common.Bonus;
import com.fantasticsource.setbonus.common.Network;
import com.fantasticsource.setbonus.common.bonusrequirements.ABonusRequirement;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.Equip;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.Set;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.SetRequirement;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.SlotData;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class ServerConfigGUI
extends GUIScreen {
    public static final int COLUMN_COUNT = 5;
    public static final double COLUMN_WIDTH = 0.2;
    public static final double SCROLLBAR_WIDTH = 0.015;
    public static final double HEADER_SCALE = 0.75;
    public static final double ELEMENT_SCALE = 0.5;
    public static double lineOffset = 0.125;
    public static Color[] lineColors = new Color[]{Color.YELLOW.copy().setAF(0.3f), Color.YELLOW.copy().setAF(0.3f)};
    public SetBonusData data;
    public GUITextLabel selected = null;
    public GUITextLabel mainLabel;
    public GUITextLabel equipsLabel;
    public GUITextLabel setsLabel;
    public GUITextLabel bonusesLabel;
    public GUITextLabel settingsLabel;
    public GUITextLabel newEquipLabel;
    public GUITextLabel newSetLabel;
    public GUITextLabel newBonusLabel;
    public GUITextLabel linesLabel;
    public GUITextLabel entryDisplayModeLabel;
    public GUITextLabel loadLocalLabel;
    public GUITextLabel saveLocalLabel;
    public GUITextLabel loadRemoteLabel;
    public GUITextLabel saveRemoteLabel;
    public GUIScrollView main;
    public GUIScrollView equips;
    public GUIScrollView bonuses;
    public GUIScrollView sets;
    public GUIScrollView settings;
    public boolean showLines = true;
    public ArrayList<GUILine> lines = new ArrayList();
    public int entryDisplayMode = 0;
    public int equipsSorting = 0;
    public int setsSorting = 0;
    public int bonusesSorting = 0;

    public ServerConfigGUI(SetBonusData data) {
        this.data = data;
        this.show();
        this.root.add((GUIElement)new GUIDarkenedBackground((GUIScreen)this));
        GUINavbar navbar = new GUINavbar((GUIScreen)this);
        this.root.add((GUIElement)navbar);
        GUIView mainColumn = new GUIView((GUIScreen)this, 0.2, 1.0 - navbar.height);
        this.root.add((GUIElement)mainColumn);
        this.mainLabel = new GUITextLabel((GUIScreen)this, 1.0, (Color)Color.GREEN, 0.75).setText(ServerConfigGUI.reformat((String)"setbonus.config.main"));
        mainColumn.add((GUIElement)this.mainLabel);
        this.main = new GUIScrollView((GUIScreen)this, 0.925, 1.0 - this.mainLabel.height, new GUIElement[0]);
        GUIVerticalScrollbar mainScrollbar = new GUIVerticalScrollbar((GUIScreen)this, 1.0 - this.main.width, this.main.height, ServerConfigGUI.getHoverColor((Color)Color.AQUA), (Color)Color.BLANK, (Color)Color.AQUA, (Color)Color.BLANK, this.main);
        mainColumn.addAll(new GUIElement[]{this.main, mainScrollbar.addEditActions(new Runnable[]{this::recalcLines})});
        GUIView equipsColumn = new GUIView((GUIScreen)this, 0.2, 1.0 - navbar.height);
        this.root.add((GUIElement)equipsColumn);
        this.equipsLabel = new GUITextLabel((GUIScreen)this, 1.0, (Color)Color.GREEN, 0.75).setText(ServerConfigGUI.reformat((String)"setbonus.config.equipment"));
        equipsColumn.add((GUIElement)this.equipsLabel);
        this.newEquipLabel = new GUITextLabel((GUIScreen)this, 1.0, (Color)Color.AQUA, 0.75).setText(ServerConfigGUI.reformat((String)"setbonus.config.createNew"));
        equipsColumn.add((GUIElement)this.newEquipLabel);
        this.equips = new GUIScrollView((GUIScreen)this, 0.925, 1.0 - this.newEquipLabel.height, new GUIElement[0]);
        GUIVerticalScrollbar equipsScrollbar = new GUIVerticalScrollbar((GUIScreen)this, 1.0 - this.equips.width, this.equips.height, ServerConfigGUI.getHoverColor((Color)Color.AQUA), (Color)Color.BLANK, (Color)Color.AQUA, (Color)Color.BLANK, this.equips);
        equipsColumn.addAll(new GUIElement[]{this.equips, equipsScrollbar.addEditActions(new Runnable[]{this::recalcLines})});
        GUIView setsColumn = new GUIView((GUIScreen)this, 0.2, 1.0 - navbar.height);
        this.root.add((GUIElement)setsColumn);
        this.setsLabel = new GUITextLabel((GUIScreen)this, 1.0, (Color)Color.GREEN, 0.75).setText(ServerConfigGUI.reformat((String)"setbonus.config.sets"));
        setsColumn.add((GUIElement)this.setsLabel);
        this.newSetLabel = new GUITextLabel((GUIScreen)this, 1.0, (Color)Color.AQUA, 0.75).setText(ServerConfigGUI.reformat((String)"setbonus.config.createNew"));
        setsColumn.add((GUIElement)this.newSetLabel);
        this.sets = new GUIScrollView((GUIScreen)this, 0.925, 1.0 - this.newSetLabel.height, new GUIElement[0]);
        GUIVerticalScrollbar setsScrollbar = new GUIVerticalScrollbar((GUIScreen)this, 1.0 - this.sets.width, this.sets.height, ServerConfigGUI.getHoverColor((Color)Color.AQUA), (Color)Color.BLANK, (Color)Color.AQUA, (Color)Color.BLANK, this.sets);
        setsColumn.addAll(new GUIElement[]{this.sets, setsScrollbar.addEditActions(new Runnable[]{this::recalcLines})});
        GUIView bonusesColumn = new GUIView((GUIScreen)this, 0.2, 1.0 - navbar.height);
        this.root.add((GUIElement)bonusesColumn);
        this.bonusesLabel = new GUITextLabel((GUIScreen)this, 1.0, (Color)Color.GREEN, 0.75).setText(ServerConfigGUI.reformat((String)"setbonus.config.bonuses"));
        bonusesColumn.add((GUIElement)this.bonusesLabel);
        this.newBonusLabel = new GUITextLabel((GUIScreen)this, 1.0, (Color)Color.AQUA, 0.75).setText(ServerConfigGUI.reformat((String)"setbonus.config.createNew"));
        bonusesColumn.add((GUIElement)this.newBonusLabel);
        this.bonuses = new GUIScrollView((GUIScreen)this, 0.925, 1.0 - this.newBonusLabel.height, new GUIElement[0]);
        GUIVerticalScrollbar bonusesScrollbar = new GUIVerticalScrollbar((GUIScreen)this, 1.0 - this.bonuses.width, this.bonuses.height, ServerConfigGUI.getHoverColor((Color)Color.AQUA), (Color)Color.BLANK, (Color)Color.AQUA, (Color)Color.BLANK, this.bonuses);
        bonusesColumn.addAll(new GUIElement[]{this.bonuses, bonusesScrollbar.addEditActions(new Runnable[]{this::recalcLines})});
        GUIView settingsColumn = new GUIView((GUIScreen)this, 0.2, 1.0 - navbar.height);
        this.root.add((GUIElement)settingsColumn);
        this.settingsLabel = new GUITextLabel((GUIScreen)this, 1.0, (Color)Color.GREEN, 0.75).setText(ServerConfigGUI.reformat((String)"setbonus.config.settings"));
        settingsColumn.add((GUIElement)this.settingsLabel);
        this.settings = new GUIScrollView((GUIScreen)this, 0.925, 1.0 - this.settingsLabel.height, new GUIElement[0]);
        GUIVerticalScrollbar settingsScrollbar = new GUIVerticalScrollbar((GUIScreen)this, 1.0 - this.settings.width, this.settings.height, ServerConfigGUI.getHoverColor((Color)Color.AQUA), (Color)Color.BLANK, (Color)Color.AQUA, (Color)Color.BLANK, this.settings);
        settingsColumn.addAll(new GUIElement[]{this.settings, settingsScrollbar.addEditActions(new Runnable[]{this::recalcLines})});
        navbar.addRecalcActions(new Runnable[]{() -> {
            mainColumn.height = 1.0 - navbar.height;
            equipsColumn.height = 1.0 - navbar.height;
            setsColumn.height = 1.0 - navbar.height;
            bonusesColumn.height = 1.0 - navbar.height;
            settingsColumn.height = 1.0 - navbar.height;
        }});
        this.mainLabel.addRecalcActions(new Runnable[]{() -> {
            mainScrollbar.height = this.main.height = 1.0 - this.mainLabel.height;
        }});
        this.newEquipLabel.addRecalcActions(new Runnable[]{() -> {
            equipsScrollbar.height = this.equips.height = 1.0 - this.newEquipLabel.height;
        }});
        this.newSetLabel.addRecalcActions(new Runnable[]{() -> {
            setsScrollbar.height = this.sets.height = 1.0 - this.newSetLabel.height;
        }});
        this.newBonusLabel.addRecalcActions(new Runnable[]{() -> {
            bonusesScrollbar.height = this.bonuses.height = 1.0 - this.newBonusLabel.height;
        }});
        this.settingsLabel.addRecalcActions(new Runnable[]{() -> {
            settingsScrollbar.height = this.settings.height = 1.0 - this.settingsLabel.height;
        }});
        this.linesLabel = new GUITextLabel((GUIScreen)this, 1.0, 0.5).setText(ServerConfigGUI.reformat((String)"setbonus.config.toggleLines"));
        this.entryDisplayModeLabel = new GUITextLabel((GUIScreen)this, 1.0, 0.5).setText(ServerConfigGUI.reformat((String)"setbonus.config.entryDisplayMode"));
        this.loadLocalLabel = new GUITextLabel((GUIScreen)this, 1.0, 0.5).setText(ServerConfigGUI.reformat((String)"setbonus.config.loadLocal"));
        this.saveLocalLabel = new GUITextLabel((GUIScreen)this, 1.0, 0.5).setText(ServerConfigGUI.reformat((String)"setbonus.config.saveLocal"));
        this.loadRemoteLabel = new GUITextLabel((GUIScreen)this, 1.0, 0.5).setText(ServerConfigGUI.reformat((String)"setbonus.config.loadRemote"));
        this.saveRemoteLabel = new GUITextLabel((GUIScreen)this, 1.0, 0.5).setText(ServerConfigGUI.reformat((String)"setbonus.config.saveRemote"));
        this.main.addAll(new GUIElement[]{this.linesLabel, this.entryDisplayModeLabel, new GUITextSpacer((GUIScreen)this), this.loadLocalLabel, this.saveLocalLabel, new GUITextSpacer((GUIScreen)this), this.loadRemoteLabel, this.saveRemoteLabel});
        for (Equip equip : data.equipment) {
            this.equips.add((GUIElement)new GUIEquip(this, data, equip, 1.0, 0.5));
        }
        this.sort(this.equips, this.equipsSorting);
        for (Set set : data.sets) {
            this.sets.add((GUIElement)new GUISet(this, data, set, 1.0, 0.5));
        }
        this.sort(this.sets, this.setsSorting);
        for (Bonus bonus : data.bonuses) {
            this.bonuses.add((GUIElement)new GUIBonus(this, data, bonus, 1.0, 0.5));
        }
        this.sort(this.bonuses, this.bonusesSorting);
        this.equipsLabel.addClickActions(new Runnable[]{() -> {
            ++this.equipsSorting;
            this.equipsSorting %= 2;
            this.sort(this.equips, this.equipsSorting);
        }});
        this.setsLabel.addClickActions(new Runnable[]{() -> {
            ++this.setsSorting;
            this.setsSorting %= 2;
            this.sort(this.sets, this.setsSorting);
        }});
        this.bonusesLabel.addClickActions(new Runnable[]{() -> {
            ++this.bonusesSorting;
            this.bonusesSorting %= 2;
            this.sort(this.bonuses, this.bonusesSorting);
        }});
        this.linesLabel.addClickActions(new Runnable[]{() -> {
            this.showLines = !this.showLines;
            this.remakeLines();
        }});
        this.entryDisplayModeLabel.addClickActions(new Runnable[]{this::changeEntryDisplayMode});
        this.loadLocalLabel.addClickActions(new Runnable[]{() -> {
            this.addPostClosedActions(new Runnable[]{() -> new ServerConfigGUI(SetBonusData.SERVER_DATA.clone())});
            this.close();
        }});
        Runnable[] runnableArray = new Runnable[1];
        runnableArray[0] = data::applyToConfig;
        this.saveLocalLabel.addClickActions(runnableArray);
        this.loadRemoteLabel.addClickActions(new Runnable[]{() -> Network.WRAPPER.sendToServer((IMessage)new Network.RequestServerDataPacket())});
        this.saveRemoteLabel.addClickActions(new Runnable[]{() -> Network.WRAPPER.sendToServer((IMessage)new Network.SetServerDataPacket(data))});
        this.newEquipLabel.addClickActions(new Runnable[]{() -> {
            Equip equip = Equip.getInstance("New" + new Color(Tools.random((int)Integer.MAX_VALUE)).hex() + ", minecraft:diamond_sword");
            data.equipment.add(equip);
            this.equips.add((GUIElement)new GUIEquip(this, data, equip, 1.0, 0.5));
        }});
        this.newSetLabel.addClickActions(new Runnable[]{() -> {
            if (data.equipment.size() == 0) {
                new MessageGUI(ServerConfigGUI.reformat((String)"setbonus.config.error"), ServerConfigGUI.reformat((String)"setbonus.config.errorNoEquips"));
            } else {
                Set set = Set.getInstance("New" + new Color(Tools.random((int)Integer.MAX_VALUE)).hex() + ", New Set, mainhand = " + ((Equip)data.equipment.iterator().next()).id, data);
                data.sets.add(set);
                this.sets.add((GUIElement)new GUISet(this, data, set, 1.0, 0.5));
            }
        }});
        this.newBonusLabel.addClickActions(new Runnable[]{() -> {
            Bonus bonus = Bonus.getInstance("New" + new Color(Tools.random((int)Integer.MAX_VALUE)).hex() + ", New Bonus, 0", data);
            data.bonuses.add(bonus);
            this.bonuses.add((GUIElement)new GUIBonus(this, data, bonus, 1.0, 0.5));
        }});
    }

    public void select(GUITextLabel selected) {
        this.selected = selected;
        for (GUIElement element : this.equips.children) {
            if (!(element instanceof GUIEquip)) continue;
            ((GUIEquip)element).setColor((Color)Color.AQUA);
        }
        for (GUIElement element : this.bonuses.children) {
            if (!(element instanceof GUIBonus)) continue;
            ((GUIBonus)element).setColor((Color)Color.AQUA);
        }
        for (GUIElement element : this.sets.children) {
            if (!(element instanceof GUISet)) continue;
            ((GUISet)element).setColor((Color)Color.AQUA);
        }
        if (selected != null) {
            selected.setColor((Color)Color.PURPLE);
        }
        this.settings.clear();
        if (selected != null) {
            this.populateSettings(selected);
        }
        this.remakeLines();
    }

    public void populateSettings(GUITextLabel label) {
        GUITextLabel button = new GUITextLabel((GUIScreen)this, 1.0, (Color)Color.AQUA, 0.5);
        button.setText(ServerConfigGUI.reformat((String)"setbonus.config.edit"));
        Runnable[] runnableArray = new Runnable[1];
        runnableArray[0] = () -> ((GUITextLabel)label).click();
        this.settings.add(button.addClickActions(runnableArray));
        this.settings.add((GUIElement)new GUITextSpacer((GUIScreen)this));
        button = new GUITextLabel((GUIScreen)this, 1.0, (Color)Color.RED, 0.5);
        button.setText(ServerConfigGUI.reformat((String)"setbonus.config.delete"));
        this.settings.add((GUIElement)button);
        button.addClickActions(new Runnable[]{() -> {
            if (Keyboard.isKeyDown((int)42)) {
                this.delete(label);
            } else {
                YesNoGUI yesNoGUI = new YesNoGUI(ServerConfigGUI.reformat((String)label.internalText.getText()), ServerConfigGUI.reformat((String)"setbonus.config.deleteThingMaybe", (Object[])new Object[]{label.internalText.getText()}));
                yesNoGUI.addPostClosedActions(new Runnable[]{() -> {
                    if (yesNoGUI.pressedYes) {
                        this.delete(label);
                    }
                }});
            }
        }});
    }

    public void delete(GUITextLabel label) {
        this.select(null);
        if (label instanceof GUIEquip) {
            this.data.delete(((GUIEquip)label).equip);
            this.sets.children.removeIf(element -> element instanceof GUISet && !this.data.sets.contains(((GUISet)element).set));
        } else if (label instanceof GUISet) {
            this.data.delete(((GUISet)label).set);
        } else if (label instanceof GUIBonus) {
            this.data.delete(((GUIBonus)label).bonus);
        }
        GUIElement parent = label.parent;
        int index = parent.indexOf((GUIElement)label);
        parent.remove(index);
        if (parent.children.size() > index) {
            this.select((GUITextLabel)parent.children.get(index));
        } else if (parent.children.size() > 0) {
            this.select((GUITextLabel)parent.children.get(index - 1));
        }
    }

    public void changeEntryDisplayMode() {
        block8: {
            block9: {
                block7: {
                    if (++this.entryDisplayMode >= 3) {
                        this.entryDisplayMode = 0;
                    }
                    if (this.entryDisplayMode != 0) break block7;
                    for (GUIElement element : this.sets.children) {
                        if (!(element instanceof GUISet)) continue;
                        ((GUISet)element).setText(ServerConfigGUI.reformat((String)((GUISet)element).set.id));
                    }
                    for (GUIElement element : this.bonuses.children) {
                        if (!(element instanceof GUIBonus)) continue;
                        ((GUIBonus)element).setText(ServerConfigGUI.reformat((String)((GUIBonus)element).bonus.id));
                    }
                    break block8;
                }
                if (this.entryDisplayMode != 1) break block9;
                for (GUIElement element : this.sets.children) {
                    if (!(element instanceof GUISet)) continue;
                    ((GUISet)element).setText(ServerConfigGUI.reformat((String)((GUISet)element).set.name));
                }
                for (GUIElement element : this.bonuses.children) {
                    if (!(element instanceof GUIBonus)) continue;
                    ((GUIBonus)element).setText(ServerConfigGUI.reformat((String)((GUIBonus)element).bonus.name));
                }
                break block8;
            }
            if (this.entryDisplayMode != 2) break block8;
            for (GUIElement element : this.sets.children) {
                if (!(element instanceof GUISet)) continue;
                ((GUISet)element).setText(ServerConfigGUI.reformat((String)((GUISet)element).set.id) + " (" + ServerConfigGUI.reformat((String)((GUISet)element).set.name) + ")");
            }
            for (GUIElement element : this.bonuses.children) {
                if (!(element instanceof GUIBonus)) continue;
                ((GUIBonus)element).setText(ServerConfigGUI.reformat((String)((GUIBonus)element).bonus.id) + " (" + ServerConfigGUI.reformat((String)((GUIBonus)element).bonus.name) + ")");
            }
        }
    }

    public void sort(GUIScrollView parent, int mode) {
        parent.children.sort((c1, c2) -> {
            if (!(c1 instanceof GUITextLabel) || !(c2 instanceof GUITextLabel)) {
                return 0;
            }
            if (mode == 0) {
                return ((GUITextLabel)c1).internalText.getText().compareTo(((GUITextLabel)c2).internalText.getText());
            }
            return ((GUITextLabel)c2).internalText.getText().compareTo(((GUITextLabel)c1).internalText.getText());
        });
        parent.recalc(0);
    }

    public void recalcLines() {
        for (GUILine line : this.lines) {
            line.recalc(0);
        }
    }

    public void remakeLines() {
        block15: {
            GUILine line;
            GUITextLabel selected;
            block16: {
                block14: {
                    GUILine line2;
                    for (GUILine line3 : this.lines) {
                        this.root.remove((GUIElement)line3);
                    }
                    this.lines.clear();
                    if (!this.showLines) {
                        return;
                    }
                    selected = this.selected;
                    if (!(selected instanceof GUIEquip)) break block14;
                    GUIEquip guiEquip = (GUIEquip)selected;
                    LinkedHashMap<Set, Object> linkedSets = new LinkedHashMap<Set, Object>();
                    for (GUIElement element : this.sets.children) {
                        if (!(element instanceof GUISet)) continue;
                        GUISet other = (GUISet)element;
                        for (SlotData slotData : other.set.slotData) {
                            if (!slotData.involvedEquips.contains(guiEquip.equip)) continue;
                            line2 = new GUILine((GUIScreen)this, selected.absoluteX() + selected.absoluteWidth() * (1.0 - lineOffset), selected.absoluteY() + selected.absoluteHeight() * 0.5, other.absoluteX() + other.absoluteWidth() * lineOffset, other.absoluteY() + other.absoluteHeight() * 0.5, lineColors[0], lineColors[1], 3.0f);
                            line2.addRecalcActions(new Runnable[]{() -> line2.set(selected.absoluteX() + selected.absoluteWidth() * (1.0 - lineOffset), selected.absoluteY() + selected.absoluteHeight() * 0.5, other.absoluteX() + other.absoluteWidth() * lineOffset, other.absoluteY() + other.absoluteHeight() * 0.5)});
                            this.lines.add(line2);
                            this.root.add((GUIElement)line2);
                            linkedSets.put(other.set, (Object)other);
                        }
                    }
                    for (GUIElement element : this.bonuses.children) {
                        if (!(element instanceof GUIBonus)) continue;
                        for (ABonusRequirement requirement : ((GUIBonus)element).bonus.requirements) {
                            GUISet guiSet;
                            if (!(requirement instanceof SetRequirement) || (guiSet = (GUISet)((Object)linkedSets.get(((SetRequirement)requirement).set))) == null) continue;
                            line2 = new GUILine((GUIScreen)this, guiSet.absoluteX() + guiSet.absoluteWidth() * (1.0 - lineOffset), guiSet.absoluteY() + guiSet.absoluteHeight() * 0.5, element.absoluteX() + element.absoluteWidth() * lineOffset, element.absoluteY() + element.absoluteHeight() * 0.5, lineColors[0], lineColors[1], 3.0f);
                            line2.addRecalcActions(new Runnable[]{() -> line2.set(guiSet.absoluteX() + guiSet.absoluteWidth() * (1.0 - lineOffset), guiSet.absoluteY() + guiSet.absoluteHeight() * 0.5, element.absoluteX() + element.absoluteWidth() * lineOffset, element.absoluteY() + element.absoluteHeight() * 0.5)});
                            this.lines.add(line2);
                            this.root.add((GUIElement)line2);
                        }
                    }
                    break block15;
                }
                if (!(selected instanceof GUIBonus)) break block16;
                GUIBonus guiBonus = (GUIBonus)selected;
                for (GUIElement other : this.sets.children) {
                    if (!(other instanceof GUISet)) continue;
                    for (ABonusRequirement requirement : guiBonus.bonus.requirements) {
                        if (!(requirement instanceof SetRequirement) || ((SetRequirement)requirement).set != ((GUISet)other).set) continue;
                        GUILine line4 = new GUILine((GUIScreen)this, other.absoluteX() + other.absoluteWidth() * (1.0 - lineOffset), other.absoluteY() + other.absoluteHeight() * 0.5, selected.absoluteX() + selected.absoluteWidth() * lineOffset, selected.absoluteY() + selected.absoluteHeight() * 0.5, lineColors[0], lineColors[1], 3.0f);
                        line4.addRecalcActions(new Runnable[]{() -> line4.set(other.absoluteX() + other.absoluteWidth() * (1.0 - lineOffset), other.absoluteY() + other.absoluteHeight() * 0.5, selected.absoluteX() + selected.absoluteWidth() * lineOffset, selected.absoluteY() + selected.absoluteHeight() * 0.5)});
                        this.lines.add(line4);
                        this.root.add((GUIElement)line4);
                        for (GUIElement other2 : this.equips.children) {
                            if (!(other2 instanceof GUIEquip)) continue;
                            for (SlotData slotData : ((GUISet)other).set.slotData) {
                                if (!slotData.involvedEquips.contains(((GUIEquip)other2).equip)) continue;
                                GUILine line2 = new GUILine((GUIScreen)this, other2.absoluteX() + other2.absoluteWidth() * (1.0 - lineOffset), other2.absoluteY() + other2.absoluteHeight() * 0.5, other.absoluteX() + other.absoluteWidth() * lineOffset, other.absoluteY() + other.absoluteHeight() * 0.5, lineColors[0], lineColors[1], 3.0f);
                                line2.addRecalcActions(new Runnable[]{() -> line2.set(other2.absoluteX() + other2.absoluteWidth() * (1.0 - lineOffset), other2.absoluteY() + other2.absoluteHeight() * 0.5, other.absoluteX() + other.absoluteWidth() * lineOffset, other.absoluteY() + other.absoluteHeight() * 0.5)});
                                this.lines.add(line2);
                                this.root.add((GUIElement)line2);
                            }
                        }
                    }
                }
                break block15;
            }
            if (!(selected instanceof GUISet)) break block15;
            GUISet guiSet = (GUISet)selected;
            for (GUIElement other : this.equips.children) {
                if (!(other instanceof GUIEquip)) continue;
                for (SlotData slotData : guiSet.set.slotData) {
                    if (!slotData.involvedEquips.contains(((GUIEquip)other).equip)) continue;
                    line = new GUILine((GUIScreen)this, other.absoluteX() + other.absoluteWidth() * (1.0 - lineOffset), other.absoluteY() + other.absoluteHeight() * 0.5, selected.absoluteX() + selected.absoluteWidth() * lineOffset, selected.absoluteY() + selected.absoluteHeight() * 0.5, lineColors[0], lineColors[1], 3.0f);
                    line.addRecalcActions(new Runnable[]{() -> line.set(other.absoluteX() + other.absoluteWidth() * (1.0 - lineOffset), other.absoluteY() + other.absoluteHeight() * 0.5, selected.absoluteX() + selected.absoluteWidth() * lineOffset, selected.absoluteY() + selected.absoluteHeight() * 0.5)});
                    this.lines.add(line);
                    this.root.add((GUIElement)line);
                }
            }
            for (GUIElement other : this.bonuses.children) {
                if (!(other instanceof GUIBonus)) continue;
                for (ABonusRequirement requirement : ((GUIBonus)other).bonus.requirements) {
                    if (!(requirement instanceof SetRequirement) || ((SetRequirement)requirement).set != guiSet.set) continue;
                    line = new GUILine((GUIScreen)this, selected.absoluteX() + selected.absoluteWidth() * (1.0 - lineOffset), selected.absoluteY() + selected.absoluteHeight() * 0.5, other.absoluteX() + other.absoluteWidth() * lineOffset, other.absoluteY() + other.absoluteHeight() * 0.5, lineColors[0], lineColors[1], 3.0f);
                    line.addRecalcActions(new Runnable[]{() -> line.set(selected.absoluteX() + selected.absoluteWidth() * (1.0 - lineOffset), selected.absoluteY() + selected.absoluteHeight() * 0.5, other.absoluteX() + other.absoluteWidth() * lineOffset, other.absoluteY() + other.absoluteHeight() * 0.5)});
                    this.lines.add(line);
                    this.root.add((GUIElement)line);
                }
            }
        }
    }

    public void show() {
        this.showStacked();
    }

    public String title() {
        return ServerConfigGUI.reformat((String)"setbonus.config.serverSettings");
    }
}

