/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.client;

import com.fantasticsource.mctools.items.AdvancedItemFilter;
import com.fantasticsource.setbonus.SetBonusData;
import com.fantasticsource.setbonus.client.ClientBonus;
import com.fantasticsource.setbonus.common.Bonus;
import com.fantasticsource.setbonus.common.bonuselements.ABonusElement;
import com.fantasticsource.setbonus.common.bonuselements.BonusElementAttributeModifier;
import com.fantasticsource.setbonus.common.bonuselements.BonusElementEnchantment;
import com.fantasticsource.setbonus.common.bonuselements.BonusElementPotionEffect;
import com.fantasticsource.setbonus.common.bonusrequirements.ABonusRequirement;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.Equip;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.Set;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.SetRequirement;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.SlotData;
import com.fantasticsource.setbonus.config.SetBonusConfig;
import com.fantasticsource.tools.Tools;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;

public class TooltipRenderer {
    protected static ArrayList<AdvancedItemFilter> itemTooltipBlacklist = new ArrayList();
    protected static ItemStack recentlyDenied = null;
    protected static ItemStack recentlyDisplayed = null;
    protected static ArrayList<String> recentlyAddedTooltips = new ArrayList();

    public static void update() {
        itemTooltipBlacklist.clear();
        for (String string : SetBonusConfig.clientSettings.itemTooltipBlacklist) {
            itemTooltipBlacklist.add(AdvancedItemFilter.getInstance((String)string));
        }
        recentlyDenied = null;
        recentlyDisplayed = null;
        recentlyAddedTooltips.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void tooltips(ItemTooltipEvent event) {
        if (!SetBonusConfig.clientSettings.enableTooltips) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        ArrayList<String> list = new ArrayList<String>();
        boolean clientThread = Thread.currentThread().getName().equals("Client thread");
        if (clientThread) {
            if (recentlyDisplayed == stack && !Keyboard.isKeyDown((int)42)) {
                if (recentlyAddedTooltips.size() > 0) {
                    event.getToolTip().add("");
                    event.getToolTip().addAll(recentlyAddedTooltips);
                }
                return;
            }
            if (recentlyDenied == stack) {
                return;
            }
            for (AdvancedItemFilter filter : itemTooltipBlacklist) {
                if (!filter.matches(stack)) continue;
                recentlyDenied = stack;
                return;
            }
            recentlyDisplayed = stack;
            recentlyAddedTooltips.clear();
        }
        for (Set set : SetBonusData.CLIENT_DATA.sets) {
            boolean showTooltip = false;
            for (SlotData slotData : set.slotData) {
                for (Equip equip : slotData.involvedEquips) {
                    if (!equip.filter.matches(stack)) continue;
                    showTooltip = true;
                    break;
                }
                if (!showTooltip) continue;
                break;
            }
            if (!showTooltip) continue;
            int count = set.getNumberEquipped(player);
            int max = set.getMaxNumber();
            String color = "" + (count == 0 ? TextFormatting.RED : (count == max ? TextFormatting.GREEN : TextFormatting.YELLOW));
            list.add(color + TextFormatting.BOLD + "=== " + I18n.func_74838_a((String)set.name) + " (" + count + "/" + max + ") ===");
            for (Bonus bonus : SetBonusData.CLIENT_DATA.bonuses) {
                int req = 0;
                boolean otherReqs = false;
                for (ABonusRequirement requirement : bonus.requirements) {
                    if (requirement instanceof SetRequirement) {
                        SetRequirement setRequirement = (SetRequirement)requirement;
                        if (setRequirement.set.id.equals(set.id)) {
                            req = Tools.max((int[])new int[]{req, setRequirement.required()});
                            continue;
                        }
                        otherReqs = true;
                        continue;
                    }
                    otherReqs = true;
                }
                if (req <= 0) continue;
                ClientBonus.BonusInstance bonusInstance = ((ClientBonus)bonus).getBonusInstance(player);
                color = "";
                int active = set.getNumberEquipped(player);
                color = bonusInstance.active ? color + TextFormatting.GREEN : (active >= req ? color + TextFormatting.DARK_PURPLE : (active == 0 ? color + TextFormatting.RED : color + TextFormatting.YELLOW));
                list.add(color + " (" + active + "/" + req + ")" + (otherReqs ? "*" : "") + " " + I18n.func_74838_a((String)bonus.name));
                if (!SetBonusConfig.clientSettings.enableAttributeModifierTooltips && !SetBonusConfig.clientSettings.enablePotionEffectTooltips && !SetBonusConfig.clientSettings.enableEnchantmentTooltips) continue;
                ArrayList<BonusElementAttributeModifier> bonusElementAttributeModifiers = new ArrayList<BonusElementAttributeModifier>();
                ArrayList<BonusElementPotionEffect> bonusElementPotionEffects = new ArrayList<BonusElementPotionEffect>();
                ArrayList<BonusElementEnchantment> bonusElementEnchantments = new ArrayList<BonusElementEnchantment>();
                for (ABonusElement element : bonus.bonusElements) {
                    if (element instanceof BonusElementAttributeModifier) {
                        bonusElementAttributeModifiers.add((BonusElementAttributeModifier)element);
                        continue;
                    }
                    if (element instanceof BonusElementPotionEffect) {
                        bonusElementPotionEffects.add((BonusElementPotionEffect)element);
                        continue;
                    }
                    if (!(element instanceof BonusElementEnchantment)) continue;
                    bonusElementEnchantments.add((BonusElementEnchantment)element);
                }
                if (SetBonusConfig.clientSettings.enableAttributeModifierTooltips) {
                    for (BonusElementAttributeModifier bonusElementAttributeModifier : bonusElementAttributeModifiers) {
                        for (String line : bonusElementAttributeModifier.tooltips()) {
                            list.add("  " + line);
                        }
                    }
                }
                if (SetBonusConfig.clientSettings.enablePotionEffectTooltips) {
                    for (BonusElementPotionEffect bonusElementPotionEffect : bonusElementPotionEffects) {
                        for (String line : bonusElementPotionEffect.tooltips()) {
                            list.add("  " + line);
                        }
                    }
                }
                if (!SetBonusConfig.clientSettings.enableEnchantmentTooltips) continue;
                for (BonusElementEnchantment bonusElementEnchantment : bonusElementEnchantments) {
                    for (String line : bonusElementEnchantment.tooltips()) {
                        list.add("  " + line);
                    }
                }
            }
            list.add("");
        }
        if (list.size() > 0) {
            event.getToolTip().add("");
            event.getToolTip().addAll(list);
        }
        if (clientThread) {
            recentlyAddedTooltips = list;
        }
    }
}

