/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.client;

import com.fantasticsource.setbonus.Compat;
import com.fantasticsource.setbonus.SetBonusData;
import com.fantasticsource.setbonus.client.TooltipRenderer;
import com.fantasticsource.setbonus.common.Bonus;
import com.fantasticsource.setbonus.common.bonusrequirements.ABonusRequirement;
import com.fantasticsource.setbonus.config.SetBonusConfig;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class ClientBonus
extends Bonus {
    public static boolean refreshJEI = false;
    private LinkedHashMap<EntityPlayer, BonusInstance> instances = new LinkedHashMap();

    public static void dropAll() {
        for (Bonus bonus : SetBonusData.CLIENT_DATA.bonuses) {
            for (BonusInstance data : ((ClientBonus)bonus).instances.values()) {
                data.update(false);
            }
        }
        SetBonusData.CLIENT_DATA.bonuses.clear();
    }

    public static void updateBonuses(EntityPlayer player) {
        for (Bonus bonus : SetBonusData.CLIENT_DATA.bonuses) {
            ((ClientBonus)bonus).update(player);
        }
        if (refreshJEI && SetBonusConfig.clientSettings.dynamicTooltipSearch > 1) {
            Compat.refreshTooltips();
            refreshJEI = false;
        }
    }

    public void update(EntityPlayer player) {
        this.instances.computeIfAbsent(player, k -> new BonusInstance()).update();
    }

    @Nonnull
    public BonusInstance getBonusInstance(EntityPlayer player) {
        BonusInstance result = this.instances.get(player);
        if (result == null) {
            result = new BonusInstance();
            result.update();
            this.instances.put(player, result);
        }
        return result;
    }

    public class BonusInstance {
        public int[] lastReqStatus = new int[0];
        public boolean active;

        private BonusInstance() {
        }

        public void update() {
            boolean activate = true;
            int[] reqStatus = new int[ClientBonus.this.requirements.size() << 1];
            int i = 0;
            for (ABonusRequirement requirement : ClientBonus.this.requirements) {
                reqStatus[i++] = requirement.active((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                reqStatus[i++] = requirement.required();
                if (reqStatus[i - 2] >= reqStatus[i - 1]) continue;
                activate = false;
            }
            this.update(activate);
            if (reqStatus.length != this.lastReqStatus.length) {
                refreshJEI = true;
            } else {
                for (i = 0; i < reqStatus.length; ++i) {
                    if (reqStatus[i] == this.lastReqStatus[i]) continue;
                    TooltipRenderer.update();
                    refreshJEI = true;
                    break;
                }
            }
            this.lastReqStatus = reqStatus;
        }

        private void update(boolean activate) {
            if (activate) {
                if (!this.active) {
                    this.active = true;
                }
            } else if (this.active) {
                this.active = false;
            }
        }
    }
}

