/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.setbonus.Compat;
import com.fantasticsource.setbonus.client.ClientBonus;
import com.fantasticsource.setbonus.client.TooltipRenderer;
import com.fantasticsource.setbonus.common.Bonus;
import com.fantasticsource.setbonus.common.Network;
import com.fantasticsource.setbonus.common.bonuselements.ABonusElement;
import com.fantasticsource.setbonus.common.bonuselements.BonusElementAttributeModifier;
import com.fantasticsource.setbonus.common.bonuselements.BonusElementEnchantment;
import com.fantasticsource.setbonus.common.bonuselements.BonusElementPotionEffect;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.Equip;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.Set;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.SetRequirement;
import com.fantasticsource.setbonus.config.SetBonusConfig;
import com.fantasticsource.setbonus.server.ServerBonus;
import java.util.LinkedHashSet;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SetBonusData {
    public static boolean setServerFromConfigCalled = false;
    public static SetBonusData SERVER_DATA = new SetBonusData();
    public static SetBonusData CLIENT_DATA = new SetBonusData();
    public LinkedHashSet<Equip> equipment = new LinkedHashSet();
    public LinkedHashSet<Set> sets = new LinkedHashSet();
    public LinkedHashSet<Bonus> bonuses = new LinkedHashSet();

    public void clear() {
        if (SERVER_DATA == this) {
            ServerBonus.dropAll();
        }
        if (CLIENT_DATA == this) {
            ClientBonus.dropAll();
        }
        this.equipment.clear();
        this.sets.clear();
        this.bonuses.clear();
    }

    public static void setServerFromConfig() {
        setServerFromConfigCalled = true;
        SERVER_DATA.setFromConfig();
        if (MCTools.hosting()) {
            for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                Network.updateConfig(player);
            }
        }
    }

    public static void setClientFromPacket(Network.AllDiscoveredBonusesPacket packet) {
        CLIENT_DATA.setFromPacket(packet);
        if (SetBonusConfig.clientSettings.dynamicTooltipSearch > 0) {
            Compat.refreshTooltips();
        }
    }

    public void setFromConfig() {
        this.clear();
        for (String equipString : SetBonusConfig.serverSettings.getEquipment()) {
            Equip equip = Equip.getInstance(equipString);
            if (equip == null) continue;
            this.equipment.add(equip);
        }
        for (String setString : SetBonusConfig.serverSettings.getSets()) {
            Set set = Set.getInstance(setString, this);
            if (set == null) continue;
            this.sets.add(set);
        }
        for (String bonusString : SetBonusConfig.serverSettings.getBonuses()) {
            ServerBonus bonus = (ServerBonus)Bonus.getInstance(bonusString, this);
            if (bonus == null) continue;
            this.bonuses.add(bonus);
        }
        for (String modifierString : SetBonusConfig.serverSettings.getAttributeMods()) {
            BonusElementAttributeModifier.getInstance(modifierString, this);
        }
        for (String potionString : SetBonusConfig.serverSettings.getPotions()) {
            BonusElementPotionEffect.getInstance(potionString, this);
        }
        for (String enchantString : SetBonusConfig.serverSettings.getEnchantments()) {
            BonusElementEnchantment.getInstance(enchantString, this);
        }
    }

    public void applyToConfig() {
        LinkedHashSet<String> equips = new LinkedHashSet<String>();
        LinkedHashSet<String> sets = new LinkedHashSet<String>();
        LinkedHashSet<String> bonuses = new LinkedHashSet<String>();
        LinkedHashSet<String> attributeModifiers = new LinkedHashSet<String>();
        LinkedHashSet<String> potions = new LinkedHashSet<String>();
        LinkedHashSet<String> enchantments = new LinkedHashSet<String>();
        for (Equip equip : this.equipment) {
            equips.add(equip.toString());
        }
        for (Set set : this.sets) {
            sets.add(set.toString());
        }
        for (Bonus bonus : this.bonuses) {
            bonuses.add(bonus.toString());
            for (ABonusElement bonusElement : bonus.bonusElements) {
                if (bonusElement instanceof BonusElementAttributeModifier) {
                    attributeModifiers.add(bonusElement.toString());
                    continue;
                }
                if (bonusElement instanceof BonusElementPotionEffect) {
                    potions.add(bonusElement.toString());
                    continue;
                }
                if (!(bonusElement instanceof BonusElementEnchantment)) continue;
                enchantments.add(bonusElement.toString());
            }
        }
        SetBonusConfig.serverSettings.equipment = equips.toArray(new String[0]);
        SetBonusConfig.serverSettings.sets = sets.toArray(new String[0]);
        SetBonusConfig.serverSettings.bonuses = bonuses.toArray(new String[0]);
        SetBonusConfig.serverSettings.attributeMods = attributeModifiers.toArray(new String[0]);
        SetBonusConfig.serverSettings.potions = potions.toArray(new String[0]);
        SetBonusConfig.serverSettings.enchantments = enchantments.toArray(new String[0]);
        ConfigManager.sync((String)"setbonus", (Config.Type)Config.Type.INSTANCE);
        SERVER_DATA.clear();
        SetBonusData.setServerFromConfig();
    }

    public void setFromPacket(Network.AllDiscoveredBonusesPacket packet) {
        this.clear();
        for (String equipString : packet.equipment) {
            Equip equip = Equip.getInstance(equipString);
            if (equip == null) continue;
            this.equipment.add(equip);
        }
        for (String setString : packet.sets) {
            Set set = Set.getInstance(setString, this);
            if (set == null) continue;
            this.sets.add(set);
        }
        for (String bonusString : packet.bonuses) {
            ClientBonus bonus = (ClientBonus)Bonus.getInstance(bonusString, this);
            if (bonus == null) continue;
            this.bonuses.add(bonus);
        }
        for (String modifierString : packet.attributeMods) {
            BonusElementAttributeModifier.getInstance(modifierString, this);
        }
        for (String potionString : packet.potions) {
            BonusElementPotionEffect.getInstance(potionString, this);
        }
        for (String enchantString : packet.enchantments) {
            BonusElementEnchantment.getInstance(enchantString, this);
        }
        if (this == CLIENT_DATA) {
            TooltipRenderer.update();
        }
    }

    public void addFromPacket(Network.DiscoverBonusPacket packet) {
        for (String equipString : packet.equipment) {
            Equip equip = Equip.getInstance(equipString);
            if (equip == null) continue;
            this.equipment.add(equip);
        }
        for (String setString : packet.sets) {
            Set set = Set.getInstance(setString, this);
            if (set == null) continue;
            this.sets.add(set);
        }
        ClientBonus bonus = (ClientBonus)Bonus.getInstance(packet.bonusString, this);
        if (bonus != null) {
            this.bonuses.add(bonus);
        }
        for (String modifierString : packet.attributeMods) {
            BonusElementAttributeModifier.getInstance(modifierString, this);
        }
        for (String potionString : packet.potions) {
            BonusElementPotionEffect.getInstance(potionString, this);
        }
        for (String enchantString : packet.enchants) {
            BonusElementEnchantment.getInstance(enchantString, this);
        }
        if (this == CLIENT_DATA) {
            TooltipRenderer.update();
        }
    }

    public void delete(Equip equip) {
        this.sets.removeIf(set -> {
            set.slotData.removeIf(slotData -> slotData.involvedEquips.remove(equip) && slotData.involvedEquips.size() == 0);
            return set.slotData.size() == 0;
        });
        for (Bonus bonus : this.bonuses) {
            for (ABonusElement element : bonus.bonusElements) {
                if (!(element instanceof BonusElementEnchantment)) continue;
                BonusElementEnchantment bEE = (BonusElementEnchantment)element;
                bEE.slotDataToEnchant.involvedEquips.remove(equip);
            }
        }
        this.equipment.remove(equip);
    }

    public void delete(Set set) {
        for (Bonus bonus : this.bonuses) {
            bonus.requirements.removeIf(requirement -> requirement instanceof SetRequirement && ((SetRequirement)requirement).set == set);
        }
        this.sets.remove(set);
    }

    public void delete(Bonus bonus) {
        this.bonuses.remove(bonus);
    }

    public SetBonusData clone() {
        SetBonusData other = new SetBonusData();
        for (Equip equip : this.equipment) {
            other.equipment.add(equip.clone());
        }
        for (Set set : this.sets) {
            other.sets.add(set.clone(other));
        }
        for (Bonus bonus : this.bonuses) {
            other.bonuses.add(bonus.clone(other));
        }
        return other;
    }
}

