/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.datastructures;

import com.fantasticsource.tools.Tools;
import java.util.HashMap;
import java.util.Map;

public class WeightedPool<T> {
    public HashMap<T, Integer> pool = new HashMap();
    public int totalWeight = 0;

    public void addWeight(T object, int weight) {
        int old = this.pool.getOrDefault(object, 0);
        if ((weight += old) <= 0) {
            this.totalWeight -= this.pool.remove(object).intValue();
        } else {
            this.pool.put(object, weight);
            this.totalWeight += weight - old;
        }
    }

    public void setWeight(T object, int weight) {
        if (weight < 0) {
            weight = 0;
        }
        this.totalWeight -= this.pool.getOrDefault(object, 0).intValue();
        if (weight == 0) {
            this.pool.remove(object);
        } else {
            this.pool.put(object, weight);
        }
        this.totalWeight += weight;
    }

    public int getWeight(T object) {
        return this.pool.getOrDefault(object, 0);
    }

    public double getChance(T object) {
        if (this.totalWeight == 0) {
            return 0.0;
        }
        return (double)this.pool.getOrDefault(object, 0).intValue() / (double)this.totalWeight;
    }

    public T getRandom() {
        if (this.totalWeight == 0) {
            return null;
        }
        int index = Tools.random(this.totalWeight);
        for (Map.Entry<T, Integer> entry : this.pool.entrySet()) {
            if (index < entry.getValue()) {
                return entry.getKey();
            }
            index -= entry.getValue().intValue();
        }
        throw new IllegalStateException();
    }

    public T getRandom(double normalizedDecimal) {
        if (this.totalWeight == 0) {
            return null;
        }
        int index = (int)((double)this.totalWeight * normalizedDecimal);
        for (Map.Entry<T, Integer> entry : this.pool.entrySet()) {
            if (index < entry.getValue()) {
                return entry.getKey();
            }
            index -= entry.getValue().intValue();
        }
        throw new IllegalStateException();
    }
}

