/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.datastructures;

import com.fantasticsource.lwjgl.Quaternion;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.TrigLookupTable;

public class VectorN {
    public static final VectorN X_AXIS = new VectorN(1.0, 0.0, 0.0);
    public static final VectorN Y_AXIS = new VectorN(0.0, 1.0, 0.0);
    public static final VectorN Z_AXIS = new VectorN(0.0, 0.0, 1.0);
    public double[] values;

    public VectorN(double ... values) {
        if (values == null) {
            throw new NullPointerException();
        }
        this.values = new double[values.length];
        System.arraycopy(values, 0, this.values, 0, values.length);
    }

    public VectorN copy() {
        return new VectorN(this.values);
    }

    public boolean isPoint() {
        for (double value : this.values) {
            if (value == 0.0) continue;
            return false;
        }
        return true;
    }

    public boolean isAllZeroes() {
        return this.isPoint();
    }

    public int zeros() {
        int count = 0;
        for (double value : this.values) {
            if (value != 0.0) continue;
            ++count;
        }
        return count;
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public double getMagnitudeSquared() {
        double squareMagnitude = 0.0;
        for (double d : this.values) {
            squareMagnitude += d * d;
        }
        return squareMagnitude;
    }

    public VectorN scale(double scalar) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = this.values[i] * scalar;
        }
        return this;
    }

    public VectorN reverse() {
        return this.scale(-1.0);
    }

    public VectorN setMagnitude(double magnitude) {
        double m = this.getMagnitude();
        if (m == 0.0) {
            return this;
        }
        double ratio = magnitude / m;
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = this.values[i] * ratio;
        }
        return this;
    }

    public VectorN normalize() {
        return this.setMagnitude(1.0);
    }

    public VectorN add(double ... values) {
        for (int i = 0; i < this.values.length && i < values.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] + values[i];
        }
        return this;
    }

    public VectorN add(VectorN ... vectors) {
        for (VectorN vector : vectors) {
            for (int i = 0; i < this.values.length && i < vector.values.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] + vector.values[i];
            }
        }
        return this;
    }

    public VectorN subtract(double ... values) {
        for (int i = 0; i < this.values.length && i < values.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] - values[i];
        }
        return this;
    }

    public VectorN subtract(VectorN ... vectors) {
        for (VectorN vector : vectors) {
            for (int i = 0; i < this.values.length && i < vector.values.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] - vector.values[i];
            }
        }
        return this;
    }

    public VectorN multiply(double ... values) {
        for (int i = 0; i < this.values.length && i < values.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] * values[i];
        }
        return this;
    }

    public VectorN multiply(VectorN ... vectors) {
        for (VectorN vector : vectors) {
            for (int i = 0; i < this.values.length && i < vector.values.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] * vector.values[i];
            }
        }
        return this;
    }

    public VectorN divide(double ... values) {
        for (int i = 0; i < this.values.length && i < values.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] / values[i];
        }
        return this;
    }

    public VectorN divide(VectorN ... vectors) {
        for (VectorN vector : vectors) {
            for (int i = 0; i < this.values.length && i < vector.values.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] / vector.values[i];
            }
        }
        return this;
    }

    public VectorN power(double ... values) {
        for (int i = 0; i < this.values.length && i < values.length; ++i) {
            this.values[i] = Math.pow(this.values[i], values[i]);
        }
        return this;
    }

    public VectorN power(VectorN ... vectors) {
        for (VectorN vector : vectors) {
            for (int i = 0; i < this.values.length && i < vector.values.length; ++i) {
                this.values[i] = Math.pow(this.values[i], vector.values[i]);
            }
        }
        return this;
    }

    public VectorN mod(double ... values) {
        for (int i = 0; i < this.values.length && i < values.length; ++i) {
            this.values[i] = this.values[i] % values[i];
        }
        return this;
    }

    public VectorN mod(VectorN ... vectors) {
        for (VectorN vector : vectors) {
            for (int i = 0; i < this.values.length && i < vector.values.length; ++i) {
                this.values[i] = this.values[i] % vector.values[i];
            }
        }
        return this;
    }

    public VectorN posMod(double ... values) {
        for (int i = 0; i < this.values.length && i < values.length; ++i) {
            this.values[i] = Tools.posMod(this.values[i], values[i]);
        }
        return this;
    }

    public VectorN posMod(VectorN ... vectors) {
        for (VectorN vector : vectors) {
            for (int i = 0; i < this.values.length && i < vector.values.length; ++i) {
                this.values[i] = Tools.posMod(this.values[i], vector.values[i]);
            }
        }
        return this;
    }

    public VectorN lowLimit(double ... values) {
        for (int i = 0; i < this.values.length && i < values.length; ++i) {
            this.values[i] = Tools.max(this.values[i], values[i]);
        }
        return this;
    }

    public VectorN lowLimit(VectorN ... vectors) {
        for (VectorN vector : vectors) {
            for (int i = 0; i < this.values.length && i < vector.values.length; ++i) {
                this.values[i] = Tools.max(this.values[i], vector.values[i]);
            }
        }
        return this;
    }

    public VectorN highLimit(double ... values) {
        for (int i = 0; i < this.values.length && i < values.length; ++i) {
            this.values[i] = Tools.min(this.values[i], values[i]);
        }
        return this;
    }

    public VectorN highLimit(VectorN ... vectors) {
        for (VectorN vector : vectors) {
            for (int i = 0; i < this.values.length && i < vector.values.length; ++i) {
                this.values[i] = Tools.min(this.values[i], vector.values[i]);
            }
        }
        return this;
    }

    public double dotProduct(VectorN vector) {
        return this.dotProduct(vector.values);
    }

    public double dotProduct(double ... values) {
        double result = 0.0;
        for (int i = 0; i < this.values.length && i < values.length; ++i) {
            result += values[i] * this.values[i];
        }
        return result;
    }

    public VectorN round() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Math.round(this.values[i]);
        }
        return this;
    }

    public VectorN floor() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Math.floor(this.values[i]);
        }
        return this;
    }

    public VectorN ceil() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Math.ceil(this.values[i]);
        }
        return this;
    }

    public VectorN abs() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Math.abs(this.values[i]);
        }
        return this;
    }

    public double squareDistanceTo(VectorN other) {
        return this.squareDistanceTo(other.values);
    }

    public double squareDistanceTo(double ... values) {
        if (this.values.length != values.length) {
            return Double.NaN;
        }
        double sumOfSquares = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sumOfSquares += (values[i] - this.values[i]) * (values[i] - this.values[i]);
        }
        return sumOfSquares;
    }

    public double distanceTo(VectorN other) {
        return this.distanceTo(other.values);
    }

    public double distanceTo(double ... values) {
        return Math.sqrt(this.squareDistanceTo(values));
    }

    public VectorN crossProduct(VectorN other) {
        double[] values = new double[this.values.length];
        System.arraycopy(this.values, 0, values, 0, values.length);
        this.values[0] = values[1] * other.values[2] - values[2] * other.values[1];
        this.values[1] = values[2] * other.values[0] - values[0] * other.values[2];
        this.values[2] = values[0] * other.values[1] - values[1] * other.values[0];
        return this;
    }

    public double angleBetween(double ... values) {
        return this.angleBetween(new VectorN(values));
    }

    public double angleBetween(VectorN other) {
        VectorN v2;
        VectorN v1;
        if (this.isPoint() || other.isPoint()) {
            return Double.NaN;
        }
        if (this.values.length == other.values.length) {
            v1 = this.copy();
            v2 = other.copy();
        } else {
            int n = Tools.min(this.values.length, other.values.length);
            v1 = new VectorN(new double[0]);
            v1.values = new double[Tools.min(this.values.length, other.values.length)];
            System.arraycopy(this.values, 0, v1.values, 0, n);
            v2 = new VectorN(new double[0]);
            v2.values = new double[Tools.min(this.values.length, other.values.length)];
            System.arraycopy(other.values, 0, v2.values, 0, n);
        }
        return TrigLookupTable.TRIG_TABLE_1048576.arccos(v1.normalize().dotProduct(v2.normalize()));
    }

    public VectorN rotate(VectorN axis, double theta) {
        return this.rotate(axis, theta, TrigLookupTable.TRIG_TABLE_1048576);
    }

    public VectorN rotate(VectorN axis, double theta, TrigLookupTable trigTable) {
        if ((theta = Tools.posMod(theta, Math.PI * 2)) == 0.0) {
            return this;
        }
        if (axis.values.length != 3) {
            throw new IllegalArgumentException("Can only use rotate() with a 3D axis; actual axis is " + axis.toString());
        }
        int axisZeroes = axis.zeros();
        if (axisZeroes == 3) {
            throw new IllegalArgumentException("Axis cannot be all zeroes!");
        }
        if (axisZeroes == 2) {
            double axisX = axis.values[0];
            double axisY = axis.values[1];
            double axisZ = axis.values[2];
            double x = this.values[0];
            double y = this.values[1];
            double z = this.values[2];
            if (theta == Math.PI) {
                if (axisX != 0.0) {
                    this.values[1] = -y;
                    this.values[2] = -z;
                    return this;
                }
                if (axisY != 0.0) {
                    this.values[0] = -x;
                    this.values[2] = -z;
                    return this;
                }
                this.values[0] = -x;
                this.values[1] = -y;
                return this;
            }
            if (axisX < 0.0 || axisY < 0.0 || axisZ < 0.0) {
                theta = Math.PI * 2 - theta;
            }
            if (axisZ != 0.0) {
                if (theta == Math.PI) {
                    this.values[0] = -x;
                    this.values[1] = -y;
                } else if (theta == 4.71238898038469) {
                    this.values[0] = y;
                    this.values[1] = -x;
                } else {
                    this.values[0] = x * TrigLookupTable.TRIG_TABLE_1048576.cos(theta) - y * TrigLookupTable.TRIG_TABLE_1048576.sin(theta);
                    this.values[1] = x * TrigLookupTable.TRIG_TABLE_1048576.sin(theta) + y * TrigLookupTable.TRIG_TABLE_1048576.cos(theta);
                }
                return this;
            }
            if (axisY != 0.0) {
                if (theta == Math.PI) {
                    this.values[0] = -x;
                    this.values[2] = -z;
                } else if (theta == 4.71238898038469) {
                    this.values[0] = -z;
                    this.values[2] = x;
                } else {
                    this.values[0] = z * TrigLookupTable.TRIG_TABLE_1048576.sin(theta) + x * TrigLookupTable.TRIG_TABLE_1048576.cos(theta);
                    this.values[2] = z * TrigLookupTable.TRIG_TABLE_1048576.cos(theta) - x * TrigLookupTable.TRIG_TABLE_1048576.sin(theta);
                }
                return this;
            }
            if (theta == Math.PI) {
                this.values[1] = -y;
                this.values[2] = -z;
            } else if (theta == 4.71238898038469) {
                this.values[1] = z;
                this.values[2] = -y;
            } else {
                this.values[1] = y * TrigLookupTable.TRIG_TABLE_1048576.cos(theta) - z * TrigLookupTable.TRIG_TABLE_1048576.sin(theta);
                this.values[2] = y * TrigLookupTable.TRIG_TABLE_1048576.sin(theta) + z * TrigLookupTable.TRIG_TABLE_1048576.cos(theta);
            }
            return this;
        }
        Quaternion quaternion = Tools.rotatedQuaternion(new Quaternion((float)this.values[0], (float)this.values[1], (float)this.values[2], 0.0f), new Quaternion((float)axis.values[0], (float)axis.values[1], (float)axis.values[2], 0.0f), theta, trigTable);
        this.values[0] = quaternion.x;
        this.values[1] = quaternion.y;
        this.values[2] = quaternion.z;
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VectorN) || ((VectorN)other).values.length != this.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == ((VectorN)other).values[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.values.length == 0) {
            return 0;
        }
        int result = Double.hashCode(this.values[0]);
        for (int i = 1; i < this.values.length; ++i) {
            result ^= Double.hashCode(this.values[i]);
        }
        return result;
    }

    public String toString() {
        if (this.values.length == 0) {
            return "()";
        }
        StringBuilder result = new StringBuilder("(" + this.values[0]);
        for (int i = 1; i < this.values.length; ++i) {
            result.append(", ").append(this.values[i]);
        }
        return result + ")";
    }
}

