/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.component.path;

import com.fantasticsource.tools.TrigLookupTable;
import com.fantasticsource.tools.component.CDouble;
import com.fantasticsource.tools.component.CVectorN;
import com.fantasticsource.tools.component.path.CPath;
import com.fantasticsource.tools.datastructures.VectorN;
import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CPathSinuous
extends CPath {
    public double thetaPerSec;
    public double thetaOffset;
    public VectorN amplitude;

    public CPathSinuous() {
    }

    public CPathSinuous(double thetaPerSec, VectorN amplitude) {
        this(thetaPerSec, 0.0, amplitude);
    }

    public CPathSinuous(double thetaPerSec, double thetaOffset, double ... values) {
        this(thetaPerSec, thetaOffset, new VectorN(values));
    }

    public CPathSinuous(double thetaPerSec, double thetaOffset, VectorN amplitude) {
        this.thetaPerSec = thetaPerSec;
        this.thetaOffset = thetaOffset;
        this.amplitude = amplitude;
    }

    @Override
    public VectorN getRelativePositionInternal(long time) {
        double normalizedScalar = TrigLookupTable.TRIG_TABLE_1048576.sin(Math.PI * 2 * (this.thetaOffset + this.thetaPerSec * (double)time / 1000.0));
        return this.amplitude.copy().scale(normalizedScalar);
    }

    @Override
    public CPathSinuous write(ByteBuf buf) {
        super.write(buf);
        new CVectorN().set(this.amplitude).write(buf);
        buf.writeDouble(this.thetaPerSec);
        buf.writeDouble(this.thetaOffset);
        return this;
    }

    @Override
    public CPathSinuous read(ByteBuf buf) {
        super.read(buf);
        this.amplitude = new CVectorN().read((ByteBuf)buf).value;
        this.thetaPerSec = buf.readDouble();
        this.thetaOffset = buf.readDouble();
        return this;
    }

    @Override
    public CPathSinuous save(OutputStream stream) {
        super.save(stream);
        new CVectorN().set(this.amplitude).save(stream);
        new CDouble().set(this.thetaPerSec).save(stream).set(this.thetaOffset).save(stream);
        return this;
    }

    @Override
    public CPathSinuous load(InputStream stream) {
        super.load(stream);
        CDouble cd = new CDouble();
        this.amplitude = new CVectorN().load((InputStream)stream).value;
        this.thetaPerSec = cd.load((InputStream)stream).value;
        this.thetaOffset = cd.load((InputStream)stream).value;
        return this;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        for (int i = 0; i < this.amplitude.values.length; ++i) {
            compound.func_74780_a("amplitude" + i, this.amplitude.values[i]);
        }
        compound.func_74780_a("n", (double)this.amplitude.values.length);
        compound.func_74780_a("thetaPerSec", this.thetaPerSec);
        compound.func_74780_a("thetaOffset", this.thetaOffset);
        return compound;
    }

    @Override
    public void deserializeNBT(NBTBase nbt) {
        super.deserializeNBT(nbt);
        NBTTagCompound compound = (NBTTagCompound)nbt;
        int n = compound.func_74762_e("n");
        double[] values = new double[n];
        for (int i = 0; i < n; ++i) {
            values[i] = compound.func_74769_h("amplitude" + i);
        }
    }
}

