/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.component.path;

import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.TrigLookupTable;
import com.fantasticsource.tools.component.CLong;
import com.fantasticsource.tools.component.CVectorN;
import com.fantasticsource.tools.component.path.CPath;
import com.fantasticsource.tools.datastructures.VectorN;
import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;

public class CPathAccelerateToTerminalVel
extends CPath {
    public long timeToTerminalVelocity;
    public VectorN terminalVelocity;

    public CPathAccelerateToTerminalVel() {
    }

    public CPathAccelerateToTerminalVel(long timeToTerminalVelocity, double ... values) {
        this(timeToTerminalVelocity, new VectorN(values));
    }

    public CPathAccelerateToTerminalVel(long timeToTerminalVelocity, VectorN terminalVelocity) {
        this.timeToTerminalVelocity = timeToTerminalVelocity;
        this.terminalVelocity = terminalVelocity;
    }

    @Override
    public VectorN getRelativePositionInternal(long time) {
        VectorN result = this.terminalVelocity.copy();
        if (this.timeToTerminalVelocity == 0L) {
            return result;
        }
        long minTime = Tools.min(time, this.timeToTerminalVelocity);
        for (int i = 0; i < result.values.length; ++i) {
            if (result.values[i] < 0.0) {
                result.values[i] = 0.5 * result.values[i] * (double)minTime - (double)this.timeToTerminalVelocity * this.terminalVelocity.values[i] * TrigLookupTable.TRIG_TABLE_1048576.sin(Math.PI * (double)minTime / (double)this.timeToTerminalVelocity) / (Math.PI * 2) + Tools.min(0.0, (double)(time - this.timeToTerminalVelocity) * this.terminalVelocity.values[i]);
                continue;
            }
            if (!(result.values[i] > 0.0)) continue;
            result.values[i] = 0.5 * result.values[i] * (double)minTime - (double)this.timeToTerminalVelocity * this.terminalVelocity.values[i] * TrigLookupTable.TRIG_TABLE_1048576.sin(Math.PI * (double)minTime / (double)this.timeToTerminalVelocity) / (Math.PI * 2) + Tools.max(0.0, (double)(time - this.timeToTerminalVelocity) * this.terminalVelocity.values[i]);
        }
        return result.scale(0.001);
    }

    @Override
    public CPathAccelerateToTerminalVel write(ByteBuf buf) {
        super.write(buf);
        buf.writeLong(this.timeToTerminalVelocity);
        new CVectorN().set(this.terminalVelocity).write(buf);
        return this;
    }

    @Override
    public CPathAccelerateToTerminalVel read(ByteBuf buf) {
        super.read(buf);
        this.timeToTerminalVelocity = buf.readLong();
        this.terminalVelocity = new CVectorN().read((ByteBuf)buf).value;
        return this;
    }

    @Override
    public CPathAccelerateToTerminalVel save(OutputStream stream) {
        super.save(stream);
        new CLong().set(this.timeToTerminalVelocity).save(stream);
        new CVectorN().set(this.terminalVelocity).save(stream);
        return this;
    }

    @Override
    public CPathAccelerateToTerminalVel load(InputStream stream) {
        super.load(stream);
        this.timeToTerminalVelocity = new CLong().load((InputStream)stream).value;
        this.terminalVelocity = new CVectorN().load((InputStream)stream).value;
        return this;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74772_a("timeToTerminalVelocity", this.timeToTerminalVelocity);
        if (this.terminalVelocity.values.length > 0) {
            NBTTagList list = new NBTTagList();
            for (double d : this.terminalVelocity.values) {
                list.func_74742_a((NBTBase)new NBTTagDouble(d));
            }
            compound.func_74782_a("terminalVelocity", (NBTBase)list);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(NBTBase nbt) {
        super.deserializeNBT(nbt);
        NBTTagCompound compound = (NBTTagCompound)nbt;
        this.timeToTerminalVelocity = compound.func_74763_f("timeToTerminalVelocity");
        this.terminalVelocity = new VectorN(new double[0]);
        if (compound.func_74764_b("terminalVelocity")) {
            NBTTagList list = (NBTTagList)compound.func_74781_a("terminalVelocity");
            this.terminalVelocity.values = new double[list.func_74745_c()];
            for (int i = 0; i < this.terminalVelocity.values.length; ++i) {
                this.terminalVelocity.values[i] = list.func_150309_d(i);
            }
        }
    }
}

