/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools;

import com.fantasticsource.tools.ReflectionTool;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import sun.reflect.ConstructorAccessor;
import sun.reflect.ReflectionFactory;

public class EnumAlterer {
    private static ReflectionFactory reflectionFactory = ReflectionFactory.getReflectionFactory();

    private static void cleanEnumCache(Class<?> enumClass) {
        ReflectionTool.set(Class.class, "enumConstantDirectory", enumClass, null);
        ReflectionTool.set(Class.class, "enumConstants", enumClass, null);
    }

    private static ConstructorAccessor getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws NoSuchMethodException {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return reflectionFactory.newConstructorAccessor(enumClass.getDeclaredConstructor(parameterTypes));
    }

    private static Object makeEnum(Class<?> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws Exception {
        Object[] params = new Object[additionalValues.length + 2];
        params[0] = value;
        params[1] = ordinal;
        System.arraycopy(additionalValues, 0, params, 2, additionalValues.length);
        return enumClass.cast(EnumAlterer.getConstructorAccessor(enumClass, additionalTypes).newInstance(params));
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName) {
        if (!Enum.class.isAssignableFrom(enumType)) {
            throw new RuntimeException("class " + enumType + " is not an instance of Enum");
        }
        Field valuesField = ReflectionTool.getField(enumType, "$VALUES");
        try {
            Enum[] previousValues = (Enum[])ReflectionTool.get(valuesField, enumType);
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
            Enum newValue = (Enum)EnumAlterer.makeEnum(enumType, enumName, values.size(), new Class[0], new Object[0]);
            values.add(newValue);
            ReflectionTool.set(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            EnumAlterer.cleanEnumCache(enumType);
            return (T)newValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void setEnumOrdinal(Enum object, int ordinal) {
        ReflectionTool.set(object.getClass().getSuperclass(), "ordinal", (Object)object, (Object)ordinal);
    }
}

