/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.potions;

import com.fantasticsource.mctools.potions.FantasticPotionEffect;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Potions {
    public static ArrayList<FantasticPotionEffect> parsePotions(String potionList) {
        return Potions.parsePotions(potionList, false);
    }

    public static ArrayList<FantasticPotionEffect> parsePotions(String[] potionList) {
        return Potions.parsePotions(potionList, false);
    }

    public static ArrayList<FantasticPotionEffect> parsePotions(String potionList, boolean ampFirst) {
        String[] potions = potionList.split("&");
        for (int i = 0; i < potions.length; ++i) {
            potions[i] = potions[i].trim();
        }
        return Potions.parsePotions(potions, ampFirst);
    }

    public static ArrayList<FantasticPotionEffect> parsePotions(String[] potionList, boolean ampFirst) {
        ArrayList<FantasticPotionEffect> result = new ArrayList<FantasticPotionEffect>();
        for (String string : potionList) {
            FantasticPotionEffect potion = Potions.parsePotion(string, ampFirst);
            if (potion == null) continue;
            result.add(potion);
        }
        return result;
    }

    public static FantasticPotionEffect parsePotion(String potionString) {
        return Potions.parsePotion(potionString, false);
    }

    public static FantasticPotionEffect parsePotion(String potionString, boolean ampFirst) {
        String durStr;
        String ampStr;
        String[] tokens;
        if ((potionString = potionString.trim()).equals("")) {
            return null;
        }
        if (!potionString.contains(":")) {
            potionString = "minecraft:" + potionString;
        }
        String regString = "";
        Potion potion = null;
        for (Map.Entry entry : ForgeRegistries.POTIONS.getEntries()) {
            String testString = ((ResourceLocation)entry.getKey()).toString();
            boolean match = testString.equals(potionString);
            if (!match) {
                boolean bl = match = testString.length() < potionString.length() && potionString.substring(0, testString.length()).equals(testString);
            }
            if (!match || testString.length() <= regString.length()) continue;
            regString = testString;
            potion = (Potion)entry.getValue();
        }
        if (regString.equals("")) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.potionNotFound", (Object[])new Object[]{potionString}));
            return null;
        }
        String[] stringArray = tokens = (potionString = potionString.replaceFirst(regString, "").replaceFirst("[.]", "").trim()).equals("") ? new String[]{} : potionString.split(Pattern.quote("."));
        if (tokens.length > 3) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.tooManyPotionArgs", (Object[])new Object[]{potionString}));
            return null;
        }
        int duration = Integer.MAX_VALUE;
        int amplifier = 0;
        int interval = 0;
        if (ampFirst) {
            if (tokens.length > 0) {
                ampStr = tokens[0].trim();
                if (ampStr.equals("*")) {
                    amplifier = Integer.MAX_VALUE;
                } else {
                    try {
                        amplifier = Integer.parseInt(tokens[0].trim());
                        if (amplifier > 0) {
                            --amplifier;
                        }
                    }
                    catch (NumberFormatException e) {
                        System.err.println(I18n.func_74837_a((String)"fantasticlib.error.potionAmpNotNumber", (Object[])new Object[]{potionString}));
                        return null;
                    }
                }
            }
            if (tokens.length > 1) {
                durStr = tokens[1].trim();
                if (durStr.equals("*")) {
                    duration = Integer.MAX_VALUE;
                } else {
                    try {
                        duration = Integer.parseInt(tokens[1].trim());
                    }
                    catch (NumberFormatException e) {
                        System.err.println(I18n.func_74837_a((String)"fantasticlib.error.potionDurNotNumber", (Object[])new Object[]{potionString}));
                        return null;
                    }
                }
            }
        } else {
            if (tokens.length > 0) {
                durStr = tokens[0].trim();
                if (durStr.equals("*")) {
                    duration = Integer.MAX_VALUE;
                } else {
                    try {
                        duration = Integer.parseInt(tokens[0].trim());
                    }
                    catch (NumberFormatException e) {
                        System.err.println(I18n.func_74837_a((String)"fantasticlib.error.potionDurNotNumber", (Object[])new Object[]{potionString}));
                        return null;
                    }
                }
            }
            if (tokens.length > 1) {
                ampStr = tokens[1].trim();
                if (ampStr.equals("*")) {
                    amplifier = Integer.MAX_VALUE;
                } else {
                    try {
                        amplifier = Integer.parseInt(tokens[1].trim());
                        if (amplifier > 0) {
                            --amplifier;
                        }
                    }
                    catch (NumberFormatException e) {
                        System.err.println(I18n.func_74837_a((String)"fantasticlib.error.potionAmpNotNumber", (Object[])new Object[]{potionString}));
                        return null;
                    }
                }
            }
        }
        if (tokens.length > 2) {
            String intrvStr = tokens[2].trim();
            if (intrvStr.equals("*")) {
                interval = Integer.MAX_VALUE;
            } else {
                try {
                    interval = Integer.parseInt(tokens[2].trim());
                }
                catch (NumberFormatException e) {
                    System.err.println(I18n.func_74837_a((String)"fantasticlib.error.potionIntrvNotNumber", (Object[])new Object[]{potionString}));
                    return null;
                }
            }
        }
        return new FantasticPotionEffect(potion, duration, amplifier, false, true).setInterval(interval);
    }
}

