/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.potions;

import com.fantasticsource.mctools.potions.BetterBrewingRecipe;
import com.fantasticsource.mctools.potions.FantasticPotionEffect;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BetterPotionType
extends PotionType {
    private static final ArrayList<BetterPotionType> POTION_TYPES_TO_ADD = new ArrayList();
    private static boolean initialized = false;
    protected PotionType recipeBasePotion;
    protected ItemStack recipeAddedItem;

    public static void init() {
        if (initialized) {
            return;
        }
        MinecraftForge.EVENT_BUS.register(BetterPotionType.class);
        initialized = true;
    }

    public BetterPotionType(PotionType recipeBasePotion, ItemStack recipeAddedItem, PotionEffect potionEffect) {
        this(potionEffect.func_76453_d().replaceAll("(.*)\\..*", "$1"), potionEffect.func_76453_d().replaceAll(".*\\.(.*)", "$1"), recipeBasePotion, recipeAddedItem, potionEffect);
    }

    public BetterPotionType(String modID, String name, PotionType recipeBasePotion, ItemStack recipeAddedItem, PotionEffect ... potionEffects) {
        super(modID + "." + name, potionEffects);
        this.recipeBasePotion = recipeBasePotion;
        this.recipeAddedItem = recipeAddedItem;
        this.setRegistryName(modID, name);
        POTION_TYPES_TO_ADD.add(this);
        BetterPotionType.init();
    }

    public BetterPotionType getLongDurationVersion() {
        PotionEffect[] potionEffects = this.func_185170_a().toArray(new PotionEffect[0]);
        for (int i = 0; i < potionEffects.length; ++i) {
            PotionEffect old = potionEffects[i];
            potionEffects[i] = new FantasticPotionEffect(old.func_188419_a(), old.func_76459_b() * 8 / 3, old.func_76458_c(), old.func_82720_e(), old.func_188418_e());
        }
        return new BetterPotionType(this.getRegistryName().func_110624_b(), "long_" + this.getRegistryName().func_110623_a(), this, new ItemStack(Items.field_151137_ax), potionEffects);
    }

    @SubscribeEvent
    public static void registerPotionTypes(RegistryEvent.Register<PotionType> event) {
        IForgeRegistry registry = event.getRegistry();
        for (BetterPotionType potionType : POTION_TYPES_TO_ADD) {
            registry.register((IForgeRegistryEntry)potionType);
            if (potionType.recipeBasePotion == null || potionType.recipeAddedItem == null) continue;
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BetterBrewingRecipe(potionType));
        }
    }
}

