/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.items;

import com.fantasticsource.tools.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class AdvancedItemFilter {
    protected String domainCheck;
    protected String itemCheck;
    protected String metaCheck;
    protected boolean domainIsRegex;
    protected boolean itemIsRegex;
    protected boolean metaIsRegex;
    protected int meta;
    protected LinkedHashMap<String, String> tagsRequired;
    protected LinkedHashMap<String, String> tagsDisallowed;
    protected int lastCacheOreDictSize = 0;
    protected ArrayList<Integer> matchingOredictIDs = new ArrayList();
    protected LinkedHashMap<Item, Boolean> cachedItemResults = new LinkedHashMap();

    public AdvancedItemFilter() {
        this(".*", ".*", ".*", null, null);
    }

    public AdvancedItemFilter(@Nullable String domainRegex, @Nullable String itemRegex, @Nullable String metaRegex, @Nullable LinkedHashMap<String, String> tagsRequired, @Nullable LinkedHashMap<String, String> tagsDisallowed) {
        this.set(domainRegex, itemRegex, metaRegex, tagsRequired, tagsDisallowed);
    }

    public void set(String domainRegex, String itemRegex, String metaRegex, LinkedHashMap<String, String> tagsRequired, LinkedHashMap<String, String> tagsDisallowed) {
        if (this.domainCheck == null) {
            this.domainCheck = ".*";
        } else {
            this.domainCheck = domainRegex.trim();
            if (this.domainCheck.isEmpty()) {
                this.domainCheck = ".*";
            }
        }
        if (this.itemCheck == null) {
            this.itemCheck = ".*";
        } else {
            this.itemCheck = itemRegex.trim();
            if (this.itemCheck.isEmpty()) {
                this.itemCheck = ".*";
            }
        }
        if (this.metaCheck == null) {
            this.metaCheck = ".*";
        } else {
            this.metaCheck = metaRegex.trim();
            if (this.metaCheck.isEmpty()) {
                this.metaCheck = ".*";
            }
        }
        this.tagsRequired = tagsRequired != null && tagsRequired.size() == 0 ? null : tagsRequired;
        this.tagsDisallowed = tagsDisallowed != null && tagsDisallowed.size() == 0 ? null : tagsDisallowed;
        this.resetAllCaches();
    }

    public void resetAllCaches() {
        this.domainIsRegex = this.domainCheck == null || Tools.hasRegexSpecialCharacters(this.domainCheck);
        this.itemIsRegex = this.itemCheck == null || Tools.hasRegexSpecialCharacters(this.itemCheck);
        boolean bl = this.metaIsRegex = this.metaCheck == null || Tools.hasRegexSpecialCharacters(this.metaCheck);
        if (!this.metaIsRegex) {
            this.meta = Integer.parseInt(this.metaCheck);
        }
        this.cachedItemResults.clear();
    }

    public String getDomainRegex() {
        return this.domainCheck;
    }

    public String getItemRegex() {
        return this.itemCheck;
    }

    public String getMetaRegex() {
        return this.metaCheck;
    }

    public LinkedHashMap<String, String> getTagsRequired() {
        if (this.tagsRequired == null) {
            return new LinkedHashMap<String, String>();
        }
        return new LinkedHashMap<String, String>(this.tagsRequired);
    }

    public LinkedHashMap<String, String> getTagsDisallowed() {
        if (this.tagsDisallowed == null) {
            return new LinkedHashMap<String, String>();
        }
        return new LinkedHashMap<String, String>(this.tagsDisallowed);
    }

    public static AdvancedItemFilter getInstance(String itemStackString) {
        AdvancedItemFilter result = new AdvancedItemFilter();
        String[] registryAndNBT = itemStackString.trim().split(Pattern.quote(">"));
        if (registryAndNBT.length == 0) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.notEnoughItemFilterArgs", (Object[])new Object[]{itemStackString}));
            return null;
        }
        if (registryAndNBT.length > 2) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.tooManyItemFilterArgs", (Object[])new Object[]{itemStackString}));
            return null;
        }
        String[] regexTokens = registryAndNBT[0].trim().split(":");
        if (regexTokens.length == 0 || regexTokens.length > 3) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.badItemName", (Object[])new Object[]{registryAndNBT[0].trim()}));
            return null;
        }
        if (regexTokens.length == 1) {
            result.domainCheck = ".*";
            result.itemCheck = regexTokens[0].trim();
            result.metaCheck = ".*";
        } else if (regexTokens.length == 2) {
            if (Tools.regexMatches(".*[a-zA-Z].*", regexTokens[1])) {
                result.domainCheck = regexTokens[0];
                result.itemCheck = regexTokens[1];
                result.metaCheck = ".*";
            } else if (Tools.regexMatches(".*[0-9].*", regexTokens[1])) {
                result.domainCheck = ".*";
                result.itemCheck = regexTokens[0];
                result.metaCheck = regexTokens[1];
            } else {
                result.domainCheck = regexTokens[0];
                result.itemCheck = regexTokens[1];
                result.metaCheck = ".*";
            }
        } else {
            result.domainCheck = regexTokens[0].trim();
            result.itemCheck = regexTokens[1].trim();
            result.metaCheck = regexTokens[2].trim();
        }
        if (result.domainCheck.equals("")) {
            result.domainCheck = ".*";
        }
        if (result.itemCheck.equals("")) {
            result.itemCheck = ".*";
        }
        if (result.metaCheck.equals("")) {
            result.metaCheck = ".*";
        }
        if (registryAndNBT.length > 1) {
            String[] tags;
            String nbt = registryAndNBT[1].trim();
            for (Map.Entry entry : ForgeRegistries.ENCHANTMENTS.getEntries()) {
                nbt = nbt.replaceAll(((ResourceLocation)entry.getKey()).toString(), "id:" + Enchantment.func_185258_b((Enchantment)((Enchantment)entry.getValue())) + "s");
            }
            for (String tag : tags = nbt.split(Pattern.quote("&"))) {
                LinkedHashMap<String, String> map;
                if ((tag = tag.trim()).equals("")) continue;
                String[] keyValue = tag.split(Pattern.quote("="));
                if (keyValue.length > 2) {
                    System.err.println(I18n.func_74837_a((String)"fantasticlib.error.tooManyNBTValues", (Object[])new Object[]{itemStackString}));
                    return null;
                }
                String key = keyValue[0].trim();
                if (key.equals("")) continue;
                if (key.charAt(0) == '!') {
                    key = key.substring(1);
                    if (result.tagsDisallowed == null) {
                        result.tagsDisallowed = new LinkedHashMap();
                    }
                    map = result.tagsDisallowed;
                } else {
                    if (result.tagsRequired == null) {
                        result.tagsRequired = new LinkedHashMap();
                    }
                    map = result.tagsRequired;
                }
                map.put(key, keyValue.length == 2 ? keyValue[1].trim() : null);
            }
        }
        result.set(result.domainCheck, result.itemCheck, result.metaCheck, result.tagsRequired, result.tagsDisallowed);
        return result;
    }

    public boolean matches(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        Boolean cachedItemCheck = this.cachedItemResults.get(item);
        if (cachedItemCheck == null) {
            ResourceLocation resourceLocation = item.getRegistryName();
            if (resourceLocation == null) {
                this.cachedItemResults.put(item, false);
                return false;
            }
            if (!this.checkDomain(resourceLocation.func_110624_b()) || !this.checkItem(resourceLocation.func_110623_a())) {
                if (stack.func_190926_b() || !this.checkDomain("ore")) {
                    this.cachedItemResults.put(item, false);
                    return false;
                }
                String[] oreDictNames = OreDictionary.getOreNames();
                for (int i = this.lastCacheOreDictSize; i < oreDictNames.length; ++i) {
                    if (!this.checkItem(oreDictNames[i])) continue;
                    this.matchingOredictIDs.add(i);
                }
                boolean found = false;
                for (int oreDictID : OreDictionary.getOreIDs((ItemStack)stack)) {
                    if (!this.matchingOredictIDs.contains(oreDictID)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.cachedItemResults.put(item, false);
                    return false;
                }
            }
            this.cachedItemResults.put(item, true);
        } else if (!cachedItemCheck.booleanValue()) {
            return false;
        }
        if (!this.checkMeta(stack.func_77960_j())) {
            return false;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && this.tagsDisallowed != null) {
            for (Map.Entry<String, String> entry : this.tagsDisallowed.entrySet()) {
                if (!this.checkNBT((NBTBase)compound, entry.getKey().split(":", -1), entry.getValue())) continue;
                return false;
            }
        }
        if (this.tagsRequired != null && this.tagsRequired.size() > 0) {
            if (compound == null) {
                return false;
            }
            for (Map.Entry<String, String> entry : this.tagsRequired.entrySet()) {
                if (this.checkNBT((NBTBase)compound, entry.getKey().split(":", -1), entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkDomain(String domain) {
        if (this.domainIsRegex) {
            return Tools.regexMatches(this.domainCheck, domain);
        }
        return this.domainCheck.equals(domain);
    }

    protected boolean checkItem(String item) {
        if (this.itemIsRegex) {
            return Tools.regexMatches(this.itemCheck, item);
        }
        return this.itemCheck.equals(item);
    }

    protected boolean checkMeta(int stackMeta) {
        if (this.metaIsRegex) {
            return Tools.regexMatches(this.metaCheck, "" + stackMeta);
        }
        return stackMeta == this.meta;
    }

    protected boolean checkNBT(NBTBase base, String[] keymap, String value) {
        if (keymap == null || keymap.length == 0) {
            return this.checkValue(base, value);
        }
        String key = keymap[0].trim();
        if (key.equals("")) {
            if (base instanceof NBTTagList) {
                for (NBTBase base1 : (NBTTagList)base) {
                    if (!this.checkNBT(base1, Arrays.copyOfRange(keymap, 1, keymap.length), value)) continue;
                    return true;
                }
            }
            return false;
        }
        if (base instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)base;
            if (!compound.func_74764_b(key)) {
                return false;
            }
            return this.checkNBT(compound.func_74781_a(key), Arrays.copyOfRange(keymap, 1, keymap.length), value);
        }
        return false;
    }

    protected boolean checkValue(NBTBase base, String value) {
        if (value == null || value.trim().equals(base.toString())) {
            return true;
        }
        if ((value = value.replace(";", ",")).equals(base.toString())) {
            return true;
        }
        String[] newValues = value.split(",");
        if (newValues.length < 2 && !value.contains(":")) {
            return false;
        }
        for (String newValue : newValues) {
            String[] tokens = newValue.split(":");
            if (this.checkNBT(base, Arrays.copyOf(tokens, tokens.length - 1), tokens[tokens.length - 1])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AdvancedItemFilter)) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return obj.equals(this);
        }
        AdvancedItemFilter other = (AdvancedItemFilter)obj;
        if (!(this.domainCheck.equals(other.domainCheck) && this.itemCheck.equals(other.itemCheck) && this.metaCheck.equals(other.metaCheck))) {
            return false;
        }
        if (this.tagsRequired.size() != other.tagsRequired.size()) {
            return false;
        }
        if (this.tagsDisallowed.size() != other.tagsDisallowed.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.tagsRequired.entrySet()) {
            if (entry.getValue().equals(other.tagsRequired.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry<String, String> entry : this.tagsDisallowed.entrySet()) {
            if (entry.getValue().equals(other.tagsDisallowed.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public AdvancedItemFilter clone() {
        AdvancedItemFilter other = new AdvancedItemFilter();
        other.domainCheck = this.domainCheck;
        other.itemCheck = this.itemCheck;
        other.metaCheck = this.metaCheck;
        if (this.tagsRequired != null) {
            other.tagsRequired = new LinkedHashMap<String, String>(this.tagsRequired);
        }
        if (this.tagsDisallowed != null) {
            other.tagsDisallowed = new LinkedHashMap<String, String>(this.tagsDisallowed);
        }
        other.lastCacheOreDictSize = this.lastCacheOreDictSize;
        other.matchingOredictIDs.addAll(this.matchingOredictIDs);
        other.domainIsRegex = this.domainIsRegex;
        other.itemIsRegex = this.itemIsRegex;
        other.metaIsRegex = this.metaIsRegex;
        other.cachedItemResults.putAll(this.cachedItemResults);
        return other;
    }

    public String toString() {
        String result = this.domainCheck + ":" + this.itemCheck + ":" + this.metaCheck;
        int i = 0;
        if (this.tagsRequired != null) {
            for (Map.Entry<String, String> entry : this.tagsRequired.entrySet()) {
                result = result + (i++ == 0 ? " > " : " & ");
                result = result + entry.getKey();
                if (entry.getValue() == null) continue;
                result = result + " = " + entry.getValue();
            }
        }
        if (this.tagsDisallowed != null) {
            for (Map.Entry<String, String> entry : this.tagsDisallowed.entrySet()) {
                result = result + (i++ == 0 ? " > " : " & ");
                result = result + "!" + entry.getKey();
                if (entry.getValue() == null) continue;
                result = result + " = " + entry.getValue();
            }
        }
        return result;
    }
}

