/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.other;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.tools.Collision;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;
import net.minecraft.client.renderer.GlStateManager;

public class GUILine
extends GUIElement {
    protected static final int TOLERANCE_PX = 5;
    protected Color color;
    protected Color hoverColor;
    protected Color activeColor;
    protected Color color2;
    protected Color hoverColor2;
    protected Color activeColor2;
    protected boolean isDownRight;
    protected boolean reverse;
    public float thickness;
    protected double x1;
    protected double y1;
    protected double x2;
    protected double y2;

    public GUILine(GUIScreen screen, double x1, double y1, double x2, double y2, Color color) {
        this(screen, x1, y1, x2, y2, color, color, color, 1.0f);
    }

    public GUILine(GUIScreen screen, double x1, double y1, double x2, double y2, Color color, float thickness) {
        this(screen, x1, y1, x2, y2, color, color, color, thickness);
    }

    public GUILine(GUIScreen screen, double x1, double y1, double x2, double y2, Color color, Color hoverColor, Color activeColor) {
        this(screen, x1, y1, x2, y2, color, hoverColor, activeColor, 1.0f);
    }

    public GUILine(GUIScreen screen, double x1, double y1, double x2, double y2, Color color, Color hoverColor, Color activeColor, float thickness) {
        this(screen, x1, y1, x2, y2, color, hoverColor, activeColor, color, hoverColor, activeColor, thickness);
    }

    public GUILine(GUIScreen screen, double x1, double y1, double x2, double y2, Color color1, Color color2) {
        this(screen, x1, y1, x2, y2, color1, color1, color1, color2, color2, color2, 1.0f);
    }

    public GUILine(GUIScreen screen, double x1, double y1, double x2, double y2, Color color1, Color color2, float thickness) {
        this(screen, x1, y1, x2, y2, color1, color1, color1, color2, color2, color2, thickness);
    }

    public GUILine(GUIScreen screen, double x1, double y1, double x2, double y2, Color color1, Color hoverColor1, Color activeColor1, Color color2, Color hoverColor2, Color activeColor2) {
        this(screen, x1, y1, x2, y2, color1, hoverColor1, activeColor1, color2, hoverColor2, activeColor2, 1.0f);
    }

    public GUILine(GUIScreen screen, double x1, double y1, double x2, double y2, Color color1, Color hoverColor1, Color activeColor1, Color color2, Color hoverColor2, Color activeColor2, float thickness) {
        super(screen, Tools.min(x1, x2), Tools.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
        this.setColor(color1, hoverColor1, activeColor1, color2, hoverColor2, activeColor2);
        this.thickness = thickness;
        this.set(x1, y1, x2, y2);
    }

    public void setColor(Color color) {
        this.setColor(color, color, color);
    }

    public void setColor(Color color, Color color2) {
        this.setColor(color, color, color, color2, color2, color2);
    }

    public void setColor(Color color, Color hoverColor, Color activeColor) {
        this.setColor(color, hoverColor, activeColor, color, hoverColor, activeColor);
    }

    public void setColor(Color color, Color hoverColor, Color activeColor, Color color2, Color hoverColor2, Color activeColor2) {
        this.color = color;
        this.hoverColor = hoverColor;
        this.activeColor = activeColor;
        this.color2 = color2;
        this.hoverColor2 = hoverColor2;
        this.activeColor2 = activeColor2;
    }

    public void set(double x1, double y1, double x2, double y2) {
        this.x = Tools.min(x1, x2);
        this.width = Math.abs(x2 - x1);
        this.y = Tools.min(y1, y2);
        this.height = Math.abs(y2 - y1);
        this.isDownRight = x1 < x2 == y1 < y2;
        this.reverse = x2 < x1;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public double getX1() {
        return this.x1;
    }

    public double getY1() {
        return this.y1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }

    @Override
    public boolean isWithin(double x, double y) {
        double[] nearest = this.isDownRight ? Collision.pointSegmentNearest(x, y, this.absoluteX(), this.absoluteY(), this.absoluteX() + this.absoluteWidth(), this.absoluteY() + this.absoluteHeight()) : Collision.pointSegmentNearest(x, y, this.absoluteX() + this.absoluteWidth(), this.absoluteY(), this.absoluteX(), this.absoluteY() + this.absoluteHeight());
        return Tools.distanceSquared(nearest[0] * (double)this.screen.pxWidth, nearest[1] * (double)this.screen.pxHeight, x * (double)this.screen.pxWidth, y * (double)this.screen.pxHeight) < (double)((this.thickness + 5.0f) * (this.thickness + 5.0f));
    }

    @Override
    public void draw() {
        Color color;
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        Color color2 = this.active ? this.activeColor : (color = this.isMouseWithin() ? this.hoverColor : this.color);
        Color color22 = this.active ? this.activeColor2 : (this.isMouseWithin() ? this.hoverColor2 : this.color2);
        GlStateManager.func_187441_d((float)this.thickness);
        GlStateManager.func_187447_r((int)1);
        GlStateManager.func_179131_c((float)color.rf(), (float)color.gf(), (float)color.bf(), (float)color.af());
        if (this.isDownRight) {
            if (this.reverse) {
                GlStateManager.func_187435_e((float)1.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)color22.rf(), (float)color22.gf(), (float)color22.bf(), (float)color22.af());
                GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)color22.rf(), (float)color22.gf(), (float)color22.bf(), (float)color22.af());
                GlStateManager.func_187435_e((float)1.0f, (float)1.0f, (float)0.0f);
            }
        } else if (this.reverse) {
            GlStateManager.func_187435_e((float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179131_c((float)color22.rf(), (float)color22.gf(), (float)color22.bf(), (float)color22.af());
            GlStateManager.func_187435_e((float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GlStateManager.func_187435_e((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179131_c((float)color22.rf(), (float)color22.gf(), (float)color22.bf(), (float)color22.af());
            GlStateManager.func_187435_e((float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_187437_J();
        GlStateManager.func_187441_d((float)1.0f);
        this.drawChildren();
    }

    public int hashCode() {
        long l = (long)(this.x1 * this.y1 * this.x2 * this.y2 * (double)this.color.color() * (double)this.color2.color());
        return (int)(l >> 32 ^ l);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GUILine)) {
            return false;
        }
        GUILine other = (GUILine)obj;
        return this.getClass() == obj.getClass() && this.x1 == other.x1 && this.y1 == other.y1 && this.x2 == other.x2 && this.y2 == other.y2 && this.thickness == other.thickness && this.color.equals(other.color) && this.hoverColor.equals(other.hoverColor) && this.activeColor.equals(other.activeColor) && this.color2.equals(other.color2) && this.hoverColor2.equals(other.hoverColor2) && this.activeColor2.equals(other.activeColor2);
    }
}

