/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.other;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.other.GUIGradientBorder;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;

public class GUIHorizontalSlider
extends GUIGradientBorder {
    private double amount = 0.5;
    private GUIGradientBorder slider;

    public GUIHorizontalSlider(GUIScreen screen, double width, double height, Color backgroundBorder, Color backgroundCenter, Color sliderBorder, Color sliderCenter) {
        super(screen, width, height, 0.3333333333333333, backgroundBorder, backgroundCenter);
        this.slider = new GUIGradientBorder(screen, -9999.0, 0.0, 0.05, 1.0, 0.3333333333333333, sliderBorder, sliderCenter);
        this.add(this.slider);
    }

    public GUIHorizontalSlider(GUIScreen screen, double x, double y, double width, double height, Color backgroundBorder, Color backgroundCenter, Color sliderBorder, Color sliderCenter) {
        super(screen, x, y, width, height, 0.3333333333333333, backgroundBorder, backgroundCenter);
        this.slider = new GUIGradientBorder(screen, -9999.0, 0.0, 0.05, 1.0, 0.3333333333333333, sliderBorder, sliderCenter);
        this.add(this.slider);
    }

    @Override
    public void draw() {
        this.slider.x = this.amount >= 0.0 && this.amount <= 1.0 ? (1.0 - this.slider.width) * this.amount : -99999.0;
        super.draw();
    }

    @Override
    public void mouseWheel(int delta) {
        if (this.amount != -1.0 && this.isMouseWithin()) {
            if (delta < 0) {
                this.amount -= 0.05;
                if (this.amount < 0.0) {
                    this.amount = 0.0;
                }
            } else {
                this.amount += 0.05;
                if (this.amount > 1.0) {
                    this.amount = 1.0;
                }
            }
        }
        this.runEditActions();
    }

    @Override
    public boolean mousePressed(int button) {
        boolean result = super.mousePressed(button);
        this.setActive(result);
        if (this.active && this.amount != -1.0) {
            this.amount = Tools.min(Tools.max((this.mouseX() - this.absoluteX() - this.slider.absoluteWidth() * 0.5) / (this.absoluteWidth() - this.slider.absoluteWidth()), 0.0), 1.0);
        }
        this.runEditActions();
        return result;
    }

    @Override
    public void mouseDrag(int button) {
        if (this.active && button == 0) {
            if (this.amount == -1.0) {
                this.setActive(false);
            } else {
                this.amount = Tools.min(Tools.max((this.mouseX() - this.absoluteX() - this.slider.absoluteWidth() * 0.5) / (this.absoluteWidth() - this.slider.absoluteWidth()), 0.0), 1.0);
            }
        }
        this.runEditActions();
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.setAmount(amount, true);
    }

    public void setAmount(double amount, boolean runEditActions) {
        this.amount = amount;
        if (runEditActions) {
            this.runEditActions();
        }
    }
}

