/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.enchantments;

import com.fantasticsource.tools.datastructures.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Enchantments {
    public static LinkedHashMap<Pair<Enchantment, Integer>, Integer> parseEnchantments(String enchantmentList) {
        String[] enchantments = enchantmentList.split("&");
        for (int i = 0; i < enchantments.length; ++i) {
            enchantments[i] = enchantments[i].trim();
        }
        return Enchantments.parseEnchantments(enchantments);
    }

    public static LinkedHashMap<Pair<Enchantment, Integer>, Integer> parseEnchantments(String[] enchantmentList) {
        LinkedHashMap<Pair<Enchantment, Integer>, Integer> result = new LinkedHashMap<Pair<Enchantment, Integer>, Integer>();
        for (String string : enchantmentList) {
            Pair<Pair<Enchantment, Integer>, Integer> enchantment = Enchantments.parseEnchantment(string);
            if (enchantment == null) continue;
            result.put(enchantment.getKey(), enchantment.getValue());
        }
        return result;
    }

    public static Pair<Pair<Enchantment, Integer>, Integer> parseEnchantment(String enchantmentString) {
        String[] tokens;
        if ((enchantmentString = enchantmentString.trim()).equals("")) {
            return null;
        }
        if (!enchantmentString.contains(":")) {
            enchantmentString = "minecraft:" + enchantmentString;
        }
        String regString = "";
        Enchantment enchantment = null;
        for (Map.Entry entry : ForgeRegistries.ENCHANTMENTS.getEntries()) {
            String testString = ((ResourceLocation)entry.getKey()).toString();
            boolean match = testString.equals(enchantmentString);
            if (!match) {
                boolean bl = match = testString.length() < enchantmentString.length() && enchantmentString.substring(0, testString.length()).equals(testString);
            }
            if (!match || testString.length() <= regString.length()) continue;
            regString = testString;
            enchantment = (Enchantment)entry.getValue();
        }
        if (regString.equals("")) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.enchantmentNotFound", (Object[])new Object[]{enchantmentString}));
            return null;
        }
        String[] stringArray = tokens = (enchantmentString = enchantmentString.replaceFirst(regString, "").replaceFirst("[.]", "").trim()).equals("") ? new String[]{} : enchantmentString.split(Pattern.quote("."));
        if (tokens.length > 2) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.tooManyEnchantmentArgs", (Object[])new Object[]{enchantmentString}));
            return null;
        }
        int mode = 0;
        int level = 1;
        if (tokens.length > 0) {
            String s = tokens[0].trim();
            if (s.equals("*")) {
                level = enchantment.func_77325_b();
            } else {
                try {
                    level = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    System.err.println(I18n.func_74837_a((String)"fantasticlib.error.enchantmentLevelNotNumber", (Object[])new Object[]{enchantmentString}));
                    return null;
                }
            }
        }
        if (tokens.length > 1) {
            try {
                mode = Integer.parseInt(tokens[1].trim());
            }
            catch (NumberFormatException e) {
                System.err.println(I18n.func_74837_a((String)"fantasticlib.error.enchantmentModeNotNumber", (Object[])new Object[]{enchantmentString}));
                return null;
            }
        }
        return new Pair<Pair<Enchantment, Integer>, Integer>(new Pair<Enchantment, Integer>(enchantment, mode), level);
    }
}

