/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.component.path;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.component.CInt;
import com.fantasticsource.tools.component.path.CPath;
import com.fantasticsource.tools.datastructures.VectorN;
import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CPathEntityPitch
extends CPath {
    public Entity entity;

    public CPathEntityPitch() {
    }

    public CPathEntityPitch(Entity entity) {
        this.entity = entity;
    }

    @Override
    public VectorN getRelativePositionInternal(long time) {
        if (this.entity == null) {
            return null;
        }
        float pitch = this.entity.field_70127_C;
        pitch += (this.entity.field_70125_A - pitch) * partialTickCached;
        return new VectorN(0.0, Tools.degtorad(pitch), 0.0);
    }

    @Override
    public CPathEntityPitch write(ByteBuf buf) {
        super.write(buf);
        buf.writeInt(this.entity.func_145782_y());
        return this;
    }

    @Override
    public CPathEntityPitch read(ByteBuf buf) {
        super.read(buf);
        this.entity = MCTools.getValidEntityByID(buf.readInt());
        return this;
    }

    @Override
    public CPathEntityPitch save(OutputStream stream) {
        super.save(stream);
        new CInt().set(this.entity.func_145782_y()).save(stream);
        return this;
    }

    @Override
    public CPathEntityPitch load(InputStream stream) {
        super.load(stream);
        this.entity = MCTools.getValidEntityByID(new CInt().load((InputStream)stream).value);
        return this;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74768_a("entity", this.entity.func_145782_y());
        return compound;
    }

    @Override
    public void deserializeNBT(NBTBase nbt) {
        super.deserializeNBT(nbt);
        NBTTagCompound compound = (NBTTagCompound)nbt;
        this.entity = MCTools.getValidEntityByID(compound.func_74762_e("entity"));
    }
}

