/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.blocks;

import com.fantasticsource.tools.Tools;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.oredict.OreDictionary;

@Deprecated
public class RegistryRegexBlockFilter {
    public String domainRegex;
    public String blockRegex;
    public String metaRegex;
    public int lastCacheOreDictSize = 0;
    public ArrayList<Integer> matchingOredictIDs = new ArrayList();

    public RegistryRegexBlockFilter() {
    }

    public RegistryRegexBlockFilter(String domainRegex, String blockRegex, String metaRegex) {
        this.domainRegex = domainRegex;
        this.blockRegex = blockRegex;
        this.metaRegex = metaRegex;
    }

    public static RegistryRegexBlockFilter getInstance(String blockStateString) {
        RegistryRegexBlockFilter result = new RegistryRegexBlockFilter();
        String[] regexTokens = blockStateString.trim().split(":");
        if (regexTokens.length == 0 || regexTokens.length > 3) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.badBlockName", (Object[])new Object[]{blockStateString.trim()}));
            return null;
        }
        if (regexTokens.length == 1) {
            result.domainRegex = ".*";
            result.blockRegex = regexTokens[0].trim();
            result.metaRegex = ".*";
        } else if (regexTokens.length == 2) {
            if (Tools.regexMatches(".*[a-zA-Z].*", regexTokens[1])) {
                result.domainRegex = regexTokens[0];
                result.blockRegex = regexTokens[1];
                result.metaRegex = ".*";
            } else if (Tools.regexMatches(".*[0-9].*", regexTokens[1])) {
                result.domainRegex = ".*";
                result.blockRegex = regexTokens[0];
                result.metaRegex = regexTokens[1];
            } else {
                result.domainRegex = regexTokens[0];
                result.blockRegex = regexTokens[1];
                result.metaRegex = ".*";
            }
        } else {
            result.domainRegex = regexTokens[0].trim();
            result.blockRegex = regexTokens[1].trim();
            result.metaRegex = regexTokens[2].trim();
        }
        if (result.domainRegex.equals("")) {
            result.domainRegex = ".*";
        }
        if (result.blockRegex.equals("")) {
            result.blockRegex = ".*";
        }
        if (result.metaRegex.equals("")) {
            result.metaRegex = ".*";
        }
        return result;
    }

    public boolean matches(IBlockState state) {
        if (!Tools.regexMatches(this.metaRegex, "" + state.func_177230_c().func_176201_c(state))) {
            return false;
        }
        ResourceLocation resourceLocation = state.func_177230_c().getRegistryName();
        if (!Tools.regexMatches(this.domainRegex, resourceLocation.func_110624_b()) || !Tools.regexMatches(this.blockRegex, resourceLocation.func_110623_a())) {
            if (state.func_177230_c() != Blocks.field_150350_a && Tools.regexMatches(this.domainRegex, "ore")) {
                String[] oreDictNames = OreDictionary.getOreNames();
                for (int i = this.lastCacheOreDictSize; i < oreDictNames.length; ++i) {
                    if (!Tools.regexMatches(this.blockRegex, oreDictNames[i])) continue;
                    this.matchingOredictIDs.add(i);
                }
                boolean found = false;
                ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
                if (!stack.func_190926_b()) {
                    for (int oreDictID : OreDictionary.getOreIDs((ItemStack)stack)) {
                        if (!this.matchingOredictIDs.contains(oreDictID)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RegistryRegexBlockFilter)) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return obj.equals(this);
        }
        RegistryRegexBlockFilter other = (RegistryRegexBlockFilter)obj;
        return this.domainRegex.equals(other.domainRegex) && this.blockRegex.equals(other.blockRegex) && this.metaRegex.equals(other.metaRegex);
    }

    public RegistryRegexBlockFilter clone() {
        RegistryRegexBlockFilter other = new RegistryRegexBlockFilter();
        other.domainRegex = this.domainRegex;
        other.blockRegex = this.blockRegex;
        other.metaRegex = this.metaRegex;
        other.lastCacheOreDictSize = this.lastCacheOreDictSize;
        other.matchingOredictIDs.addAll(this.matchingOredictIDs);
        return other;
    }

    public String toString() {
        return this.domainRegex + ":" + this.blockRegex + ":" + this.metaRegex;
    }
}

