/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import com.fantasticsource.mctools.Slottings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class DataFiles {
    private static String modDir = Loader.instance().getConfigDir().getAbsolutePath() + File.separator + "fantasticlib" + File.separator;
    private static String referenceDir = modDir + "reference" + File.separator;

    public static void output() {
        File file = new File(modDir);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(referenceDir)).exists()) {
            file.mkdir();
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(referenceDir + "entities.txt")));
            for (ResourceLocation resourceLocation : ForgeRegistries.ENTITIES.getKeys()) {
                writer.write(resourceLocation.toString() + "\r\n");
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(referenceDir + "items.txt")));
            for (ResourceLocation resourceLocation : ForgeRegistries.ITEMS.getKeys()) {
                writer.write(resourceLocation.toString() + "\r\n");
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(referenceDir + "blocks.txt")));
            for (ResourceLocation resourceLocation : ForgeRegistries.BLOCKS.getKeys()) {
                writer.write(resourceLocation.toString() + "\r\n");
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(referenceDir + "blockstates.txt")));
            for (ResourceLocation resourceLocation : ForgeRegistries.BLOCKS.getKeys()) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
                ArrayList<IBlockState> states = new ArrayList<IBlockState>();
                for (int i = 0; i < 16; ++i) {
                    IBlockState state;
                    try {
                        state = block.func_176203_a(i);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (states.contains(state)) continue;
                    states.add(state);
                    writer.write(resourceLocation.toString() + ":" + i + "\r\n");
                }
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(referenceDir + "potions.txt")));
            for (ResourceLocation resourceLocation : ForgeRegistries.POTIONS.getKeys()) {
                writer.write(resourceLocation.toString() + "\r\n");
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(referenceDir + "potion_types.txt")));
            for (ResourceLocation resourceLocation : ForgeRegistries.POTION_TYPES.getKeys()) {
                writer.write(resourceLocation.toString() + "\r\n");
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(referenceDir + "recipes.txt")));
            for (ResourceLocation resourceLocation : ForgeRegistries.RECIPES.getKeys()) {
                writer.write(resourceLocation.toString() + "\r\n");
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(referenceDir + "biomes.txt")));
            for (ResourceLocation resourceLocation : ForgeRegistries.BIOMES.getKeys()) {
                writer.write(resourceLocation.toString() + "\r\n");
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(referenceDir + "enchantments.txt")));
            for (ResourceLocation resourceLocation : ForgeRegistries.ENCHANTMENTS.getKeys()) {
                writer.write(resourceLocation.toString() + "\r\n");
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(referenceDir + "sounds.txt")));
            for (ResourceLocation resourceLocation : ForgeRegistries.SOUND_EVENTS.getKeys()) {
                writer.write(resourceLocation.toString() + "\r\n");
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(referenceDir + "villager_professions.txt")));
            for (ResourceLocation resourceLocation : ForgeRegistries.VILLAGER_PROFESSIONS.getKeys()) {
                writer.write(resourceLocation.toString() + "\r\n");
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(referenceDir + "loot_tables.txt")));
            for (ResourceLocation resourceLocation : LootTableList.func_186374_a()) {
                writer.write(resourceLocation.toString() + "\r\n");
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(referenceDir + "oredict.txt")));
            for (String string : OreDictionary.getOreNames()) {
                writer.write(string + "\r\n");
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(referenceDir + "slottings.txt")));
            for (String string : Slottings.availableSlottings()) {
                writer.write(string + "\r\n");
            }
            writer.close();
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                LinkedHashSet<String> keybindCategories = new LinkedHashSet<String>();
                Object[] keyBindings = (KeyBinding[])ArrayUtils.clone((Object[])Minecraft.func_71410_x().field_71474_y.field_74324_K);
                Arrays.sort(keyBindings);
                for (Object keyBinding : keyBindings) {
                    keybindCategories.add(keyBinding.func_151466_e());
                }
                writer = new BufferedWriter(new FileWriter(new File(referenceDir + "keybinds.txt")));
                for (String keybindCategory : keybindCategories) {
                    writer.write(keybindCategory + "\r\n");
                    for (Object keyBinding : keyBindings) {
                        if (!keyBinding.func_151466_e().equals(keybindCategory)) continue;
                        writer.write(keyBinding.func_151464_g() + "\r\n");
                    }
                    writer.write("\r\n");
                }
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

