/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockProtection {
    private static boolean initialized = false;

    private static void init() {
        if (!initialized) {
            initialized = true;
            MinecraftForge.EVENT_BUS.register(BlockProtection.class);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void blockBreakSpeed(PlayerEvent.BreakSpeed event) {
        Entity entity = event.getEntity();
        if (BlockProtection.isBuildProtected(entity.field_70170_p, event.getPos(), entity, (Event)event)) {
            event.setNewSpeed(0.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void blockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Vec3d vec = event.getHitVec();
        if (vec == null || BlockProtection.isBuildProtected(event.getWorld(), new BlockPos(event.getHitVec()), event.getEntity(), (Event)event)) {
            event.setUseItem(Event.Result.DENY);
            event.setUseBlock(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void bucketUse(FillBucketEvent event) {
        RayTraceResult rayTrace = event.getTarget();
        if (rayTrace == null || BlockProtection.isBuildProtected(event.getWorld(), new BlockPos(rayTrace.field_72307_f), event.getEntity(), (Event)event)) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void blockRightClick(PlayerInteractEvent.RightClickBlock event) {
        Vec3d vec = event.getHitVec();
        if (vec == null || BlockProtection.isBuildProtected(event.getWorld(), new BlockPos(event.getHitVec()), event.getEntity(), (Event)event)) {
            event.setUseItem(Event.Result.DENY);
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void blockPlace(BlockEvent.PlaceEvent event) {
        if (BlockProtection.isBuildProtected(event.getWorld(), event.getPos(), (Entity)event.getPlayer(), (Event)event)) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void blockMultiPlace(BlockEvent.MultiPlaceEvent event) {
        for (BlockSnapshot snapshot : event.getReplacedBlockSnapshots()) {
            if (!BlockProtection.isBuildProtected(snapshot.getWorld(), snapshot.getPos(), (Entity)event.getPlayer(), (Event)event)) continue;
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDetonation(ExplosionEvent.Detonate event) {
        World world = event.getWorld();
        List list = event.getAffectedBlocks();
        for (BlockPos pos : list.toArray(new BlockPos[list.size()])) {
            if (!BlockProtection.isBuildProtected(world, pos, null, (Event)event)) continue;
            list.remove(pos);
        }
    }

    public static boolean isBuildProtected(World world, BlockPos pos, Entity entity, Event originalEvent) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
            return false;
        }
        return MinecraftForge.EVENT_BUS.post((Event)new AlterBlockEvent(world, pos, entity, originalEvent));
    }

    static {
        BlockProtection.init();
    }

    @Cancelable
    public static class AlterBlockEvent
    extends Event {
        public final World world;
        public final BlockPos blockPos;
        public final Entity entityAltering;
        public final Event originalEvent;

        public AlterBlockEvent(World world, BlockPos blockPos, @Nullable Entity entityAltering, Event originalEvent) {
            this.world = world;
            this.blockPos = blockPos;
            this.entityAltering = entityAltering;
            this.originalEvent = originalEvent;
        }

        static {
            BlockProtection.init();
        }
    }
}

