/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.tiles;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xyz.dogboy.swp.blocks.BlockWoodenVariation;
import xyz.dogboy.swp.config.SWPConfig;
import xyz.dogboy.swp.tiles.PersistantSyncableTileEntity;
import xyz.dogboy.swp.tiles.TilePump;
import xyz.dogboy.swp.tiles.WoodenVariationProvider;
import xyz.dogboy.swp.utils.PipePriorityMap;
import xyz.dogboy.swp.utils.Utils;

public class TilePipe
extends PersistantSyncableTileEntity
implements ITickable,
WoodenVariationProvider {
    public static final int PRIORITY_BLOCK = -1000;
    public static final int PRIORITY_PIPE = 0;
    private ItemStack cachedBaseBlock;
    private FluidTank tank;
    private EnumFacing lastTransfer;
    private final boolean[] from = new boolean[EnumFacing.field_82609_l.length];
    private boolean extraction;
    private boolean clogged = false;
    private boolean syncTank;
    private boolean syncCloggedFlag;
    private boolean syncTransfer;
    private int lastRobin;
    private int ticksSinceLastUpdate;

    public TilePipe() {
        this.initFluidTank();
    }

    protected void initFluidTank() {
        this.tank = new FluidTank(SWPConfig.internalVolume){

            protected void onContentsChanged() {
                TilePipe.this.func_70296_d();
            }
        };
    }

    @Nonnull
    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.requiresSync()) {
            NBTTagCompound updateTag = this.getSyncTag();
            this.resetSync();
            return new SPacketUpdateTileEntity(this.func_174877_v(), 0, updateTag);
        }
        return null;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.tank.getFluid() != null && this.tank.getFluid().getFluid().getTemperature() >= 550 && Utils.isBurnable(this.getBaseBlock())) {
            this.func_145831_w().func_175656_a(this.func_174877_v(), Blocks.field_150480_ab.func_176223_P());
            return;
        }
        ++this.ticksSinceLastUpdate;
        boolean fluidMoved = false;
        FluidStack passStack = this.tank.drain(SWPConfig.transferRate, false);
        if (passStack != null) {
            PipePriorityMap<Integer, EnumFacing> possibleDirections = new PipePriorityMap<Integer, EnumFacing>();
            IFluidHandler[] fluidHandlers = new IFluidHandler[EnumFacing.field_82609_l.length];
            for (EnumFacing facing : EnumFacing.values()) {
                TileEntity tileEntity;
                if (!this.isConnected(facing) || this.isFrom(facing) || (tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || !tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) continue;
                IFluidHandler fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
                int priority = -1000;
                if (tileEntity instanceof TilePump) continue;
                if (tileEntity instanceof TilePipe) {
                    priority = ((TilePipe)tileEntity).getPriority(facing.func_176734_d());
                }
                if (this.isFrom(facing.func_176734_d())) {
                    priority -= 20;
                }
                if (this.isExtractionEnabled() && !(tileEntity instanceof TilePipe)) {
                    priority = Integer.MAX_VALUE;
                }
                possibleDirections.put(priority, facing);
                fluidHandlers[facing.func_176745_a()] = fluidHandler;
            }
            Iterator iterator = possibleDirections.keySet().iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                ArrayList list = possibleDirections.get(key);
                for (int i = 0; i < list.size(); ++i) {
                    EnumFacing facing = (EnumFacing)list.get((i + this.lastRobin) % list.size());
                    IFluidHandler handler = fluidHandlers[facing.func_176745_a()];
                    fluidMoved = this.pushStack(passStack, facing, handler);
                    if (this.lastTransfer != facing) {
                        this.syncTransfer = true;
                        this.lastTransfer = facing;
                        this.func_70296_d();
                    }
                    if (!fluidMoved) continue;
                    ++this.lastRobin;
                    break;
                }
                if (!fluidMoved) continue;
                break;
            }
        }
        if (this.tank.canFill() && this.isExtractionEnabled()) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IFluidHandler fluidHandler;
                TileEntity tileEntity;
                if (!this.isConnected(facing) || this.isFrom(facing) || (tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || tileEntity instanceof TilePump || tileEntity instanceof TilePipe || !tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()) || (fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) == null || !this.pumpStack(fluidHandler)) continue;
                fluidMoved = true;
                this.func_70296_d();
                break;
            }
        }
        if (this.tank.getFluidAmount() <= 0) {
            if (this.lastTransfer != null && !fluidMoved) {
                this.syncTransfer = true;
                this.lastTransfer = null;
                this.func_70296_d();
            }
            fluidMoved = true;
            if (this.ticksSinceLastUpdate > 20) {
                this.ticksSinceLastUpdate = 0;
                this.resetFrom();
            }
        }
        if (this.clogged == fluidMoved) {
            this.clogged = !fluidMoved;
            this.syncCloggedFlag = true;
            this.func_70296_d();
        }
    }

    public int getPriority(EnumFacing facing) {
        return 0;
    }

    private boolean isConnected(EnumFacing facing) {
        BlockPos pos = this.func_174877_v().func_177972_a(facing);
        TileEntity tileEntity = this.func_145831_w().func_175625_s(pos);
        return this.canConnectTo(tileEntity, facing, false);
    }

    private boolean isFrom(EnumFacing facing) {
        return this.from[facing.func_176745_a()];
    }

    private void resetFrom() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.setFrom(facing, false);
        }
    }

    private void setFrom(EnumFacing facing, boolean flag) {
        this.from[facing.func_176745_a()] = flag;
    }

    private boolean pushStack(FluidStack passStack, EnumFacing facing, IFluidHandler handler) {
        int added = handler.fill(passStack, false);
        if (added > 0) {
            handler.fill(passStack, true);
            this.tank.drain(added, true);
            passStack.amount -= added;
            return passStack.amount <= 0;
        }
        if (this.isFrom(facing)) {
            this.setFrom(facing, true);
        }
        return false;
    }

    private boolean pumpStack(IFluidHandler fluidHandler) {
        int drainAmount = Math.min(SWPConfig.transferRate, this.tank.getCapacity() - this.tank.getFluidAmount());
        FluidStack drained = fluidHandler.drain(drainAmount, false);
        if (drained != null && drained.amount > 0 && this.tank.fill(drained, false) > 0) {
            int filled = this.tank.fill(drained, true);
            fluidHandler.drain(filled, true);
            return true;
        }
        return false;
    }

    public boolean isExtractionEnabled() {
        return this.extraction;
    }

    public void setExtractionEnabled(boolean extraction) {
        this.extraction = extraction;
        this.triggerUpdate();
    }

    protected void resetSync() {
        this.syncTank = false;
        this.syncCloggedFlag = false;
        this.syncTransfer = false;
    }

    protected boolean requiresSync() {
        return this.syncTank || this.syncCloggedFlag || this.syncTransfer;
    }

    protected NBTTagCompound getSyncTag() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.syncTank) {
            this.writeTank(compound);
        }
        if (this.syncCloggedFlag) {
            this.writeCloggedFlag(compound);
        }
        if (this.syncTransfer) {
            this.writeLastTransfer(compound);
        }
        return compound;
    }

    @Override
    public void writeData(@Nonnull NBTTagCompound tag) {
        this.writeTank(tag);
        this.writeCloggedFlag(tag);
        this.writeLastTransfer(tag);
        this.writeExtraction(tag);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            tag.func_74757_a("from" + facing.func_176745_a(), this.from[facing.func_176745_a()]);
        }
        tag.func_74768_a("lastRobin", this.lastRobin);
    }

    private void writeCloggedFlag(NBTTagCompound tag) {
        tag.func_74757_a("clogged", this.clogged);
    }

    private void writeLastTransfer(NBTTagCompound tag) {
        tag.func_74768_a("lastTransfer", Utils.writeNullableFacing(this.lastTransfer));
    }

    private void writeTank(NBTTagCompound tag) {
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
    }

    private void writeExtraction(NBTTagCompound tag) {
        tag.func_74757_a("CanExtract", this.extraction);
    }

    @Override
    public void readData(@Nonnull NBTTagCompound tag) {
        if (tag.func_74764_b("clogged")) {
            this.clogged = tag.func_74767_n("clogged");
        }
        if (tag.func_74764_b("tank")) {
            this.tank.readFromNBT(tag.func_74775_l("tank"));
        }
        if (tag.func_74764_b("lastTransfer")) {
            this.lastTransfer = Utils.readNullableFacing(tag.func_74762_e("lastTransfer"));
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!tag.func_74764_b("from" + facing.func_176745_a())) continue;
            this.from[facing.func_176745_a()] = tag.func_74767_n("from" + facing.func_176745_a());
        }
        if (tag.func_74764_b("lastRobin")) {
            this.lastRobin = tag.func_74762_e("lastRobin");
        }
        if (tag.func_74764_b("CanExtract")) {
            this.extraction = tag.func_74767_n("CanExtract");
        }
    }

    public ItemStack getBaseBlock() {
        if (this.cachedBaseBlock == null) {
            if (!this.getTileData().func_74764_b("BaseBlock")) {
                return new ItemStack(Blocks.field_150350_a);
            }
            NBTTagCompound baseBlock = this.getTileData().func_74775_l("BaseBlock");
            this.cachedBaseBlock = new ItemStack(baseBlock);
        }
        return this.cachedBaseBlock;
    }

    @Override
    public IExtendedBlockState writeExtendedState(IExtendedBlockState state) {
        Block block;
        ItemStack stack;
        String texture = this.getTileData().func_74779_i("Texture");
        if (texture.isEmpty() && !(stack = this.getBaseBlock()).func_190926_b() && (block = Block.func_149634_a((Item)stack.func_77973_b())) != Blocks.field_150350_a) {
            texture = Utils.getTextureFromBlock(block, stack.func_77952_i());
            this.getTileData().func_74778_a("Texture", texture);
        }
        return state.withProperty((IUnlistedProperty)BlockWoodenVariation.TEXTURE, (Object)(texture.isEmpty() ? "minecraft:blocks/planks_oak" : texture));
    }

    public boolean canConnectTo(EnumFacing direction, boolean excludePipe) {
        return this.canConnectTo(this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(direction)), direction, excludePipe);
    }

    public boolean canConnectTo(TileEntity tileEntity, EnumFacing direction, boolean excludePipe) {
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity instanceof TilePump) {
            return direction == EnumFacing.DOWN && !excludePipe;
        }
        if (tileEntity instanceof TilePipe) {
            if (excludePipe) {
                return false;
            }
            TilePipe otherPipe = (TilePipe)tileEntity;
            if (SWPConfig.variantInterconnection) {
                return Utils.isBurnable(otherPipe.getBaseBlock()) == Utils.isBurnable(this.getBaseBlock());
            }
            return otherPipe.getBaseBlock().func_77969_a(this.getBaseBlock());
        }
        return tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d());
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getTank();
        }
        return null;
    }
}

