/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.event;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xyz.dogboy.swp.Registry;
import xyz.dogboy.swp.SimpleWoodenPipes;
import xyz.dogboy.swp.client.BakedWoodenVariationModel;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)Registry.PIPE_ITEM, (int)0, (ModelResourceLocation)new ModelResourceLocation(Registry.PIPE_ITEM.getRegistryName(), "normal"));
        ModelLoader.setCustomModelResourceLocation((Item)Registry.PUMP_ITEM, (int)0, (ModelResourceLocation)new ModelResourceLocation(Registry.PUMP_ITEM.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        for (ModelResourceLocation model : event.getModelRegistry().func_148742_b()) {
            if (!model.func_110624_b().equals("simplewoodenpipes")) continue;
            if (model.func_110623_a().equals("pipe")) {
                this.replaceWoodenVariationModel(model, Arrays.asList("main", "particle"), event);
                continue;
            }
            if (!model.func_110623_a().equals("pump")) continue;
            this.replaceWoodenVariationModel(model, Collections.singletonList("pipe"), event);
        }
    }

    private void replaceWoodenVariationModel(ModelResourceLocation modelLocation, List<String> replaceTextures, ModelBakeEvent event) {
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)modelLocation);
            IBakedModel baseModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)modelLocation);
            BakedWoodenVariationModel modifiedModel = new BakedWoodenVariationModel(baseModel, model, replaceTextures);
            event.getModelRegistry().func_82595_a((Object)modelLocation, (Object)modifiedModel);
        }
        catch (Exception e) {
            SimpleWoodenPipes.LOGGER.error("Failed to replace model for: {} with exception {}", (Object)modelLocation, (Object)e);
        }
    }
}

