/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import xyz.dogboy.swp.SimpleWoodenPipes;
import xyz.dogboy.swp.config.CfgParser;

public final class CfgHandler<T extends CfgParser.ConfigItem> {
    private final List<T> configItems = new ArrayList<T>();
    private final String[] configData;
    private final Function<String, T> parser;

    public CfgHandler(String[] configData, Function<String, T> parser) {
        this.configData = configData;
        this.parser = parser;
    }

    public CfgHandler<T> init() {
        for (String line : this.configData) {
            try {
                CfgParser.ConfigItem entry = (CfgParser.ConfigItem)this.parser.apply(line);
                this.configItems.add(entry);
            }
            catch (Exception e) {
                SimpleWoodenPipes.LOGGER.error("Error parsing config data: {}", (Object)line, (Object)e);
            }
        }
        return this;
    }

    public boolean contains(ItemStack stack) {
        return this.configItems.stream().anyMatch(item -> item.compare(stack));
    }
}

