/*
 * Decompiled with CFR 0.152.
 */
package lykrast.harvestersnight.common;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ItemHarvesterScythe
extends ItemSword {
    public ItemHarvesterScythe(Item.ToolMaterial material) {
        super(material);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (state.func_185887_b(worldIn, pos) != 0.0f) {
            stack.func_77972_a(1, entityLiving);
        }
        return true;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        Block block = blockIn.func_177230_c();
        if (block == Blocks.field_150321_G || block == Blocks.field_150395_bd || block == Blocks.field_150362_t || block == Blocks.field_150361_u) {
            return true;
        }
        Material material = blockIn.func_185904_a();
        return material == Material.field_151584_j || material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151569_G;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (!this.canHarvestBlock(state, stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return false;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int used = 0;
        if (player.func_70093_af()) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return false;
        }
        for (int i = x - 3; i <= x + 3; ++i) {
            for (int j = z - 3; j <= z + 3; ++j) {
                for (int k = y - 1; k <= y + 1; ++k) {
                    if (!this.harvestBlock(world, new BlockPos(i, k, j), player)) continue;
                    ++used;
                }
            }
        }
        if (used > 0 && !player.field_71075_bZ.field_75098_d) {
            stack.func_77972_a(used, (EntityLivingBase)player);
        }
        return false;
    }

    protected boolean harvestBlock(World world, BlockPos pos, EntityPlayer player) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        EntityPlayerMP playerMP = null;
        if (player instanceof EntityPlayerMP) {
            playerMP = (EntityPlayerMP)player;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!this.canHarvestBlock(state, player.func_184614_ca())) {
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            return false;
        }
        int xpToDrop = 0;
        if (playerMP != null && (xpToDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos)) == -1) {
            return false;
        }
        if (!world.field_72995_K) {
            if (block.removedByPlayer(state, world, pos, player, !player.field_71075_bZ.field_75098_d)) {
                block.func_176206_d(world, pos, state);
                if (!player.field_71075_bZ.field_75098_d) {
                    block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
                    if (xpToDrop > 0) {
                        block.func_180637_b(world, pos, xpToDrop);
                    }
                }
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            if (block.removedByPlayer(state, world, pos, player, !player.field_71075_bZ.field_75098_d)) {
                block.func_176206_d(world, pos, state);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_185308_t) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

