/*
 * Decompiled with CFR 0.152.
 */
package lykrast.harvestersnight.common;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="harvestersnight")
@Config.LangKey(value="config.harvestersnight.title")
public class HarvestersNightConfig {
    @Config.RangeInt(min=0)
    @Config.RequiresMcRestart
    @Config.LangKey(value="config.harvestersnight.weight")
    @Config.Comment(value={"Spawn weight of the Harvester", "0 disables natural spawn"})
    public static int harvesterWeight = 5;
    @Config.RangeInt(min=1)
    @Config.LangKey(value="config.harvestersnight.chance")
    @Config.Comment(value={"1 in X chance that the Harvester actually spawns when it can"})
    public static int harvesterChance = 50;
    @Config.LangKey(value="config.harvestersnight.mode")
    @Config.Comment(value={"Is the dimension ID list a whitelist (true) or blacklist (false)?"})
    public static boolean whiteList = true;
    @Config.LangKey(value="config.harvestersnight.dim")
    @Config.Comment(value={"Dimension IDs the Harvester is (dis)allowed to spawn in"})
    public static int[] dimList = new int[]{0};
    @Config.LangKey(value="config.harvestersnight.isboss")
    @Config.Comment(value={"Whether the Harvester is internally considered a boss (some mods care)"})
    public static boolean isBoss = true;
    @Config.LangKey(value="config.harvestersnight.healthbar")
    @Config.Comment(value={"Whether a boss health bar is shown or not"})
    public static boolean healthBar = true;
    @Config.LangKey(value="config.harvestersnight.lightning")
    @Config.Comment(value={"Whether lightning strikes when the Harvester spawns"})
    public static boolean lightning = true;
    @Config.LangKey(value="config.harvestersnight.laugh")
    @Config.Comment(value={"Whether the Harvester laughs when it spawns"})
    public static boolean laugh = true;

    @Mod.EventBusSubscriber(modid="harvestersnight")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("harvestersnight")) {
                ConfigManager.sync((String)"harvestersnight", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

