/*
 * Decompiled with CFR 0.152.
 */
package lykrast.harvestersnight.common;

import lykrast.harvestersnight.common.CommonProxy;
import lykrast.harvestersnight.common.EntityHarvester;
import lykrast.harvestersnight.common.HarvestersNightConfig;
import lykrast.harvestersnight.common.ItemHarvesterScythe;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="harvestersnight", name="Harvester's Night", version="1.1.0", acceptedMinecraftVersions="[1.12, 1.13)")
@Mod.EventBusSubscriber
public class HarvestersNight {
    public static final String MODID = "harvestersnight";
    public static final String NAME = "Harvester's Night";
    public static final String VERSION = "1.1.0";
    public static Logger logger = LogManager.getLogger((String)"harvestersnight");
    @SidedProxy(clientSide="lykrast.harvestersnight.client.ClientProxy", serverSide="lykrast.harvestersnight.common.CommonProxy")
    public static CommonProxy proxy;
    public static Item.ToolMaterial harvesterMaterial;
    public static Item harvesterScythe;
    public static SoundEvent harvesterCharge;
    public static SoundEvent harvesterSpell;
    public static SoundEvent harvesterSpawn;
    public static SoundEvent harvesterHurt;
    public static SoundEvent harvesterDie;

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        harvesterMaterial = EnumHelper.addToolMaterial((String)"harvester", (int)Item.ToolMaterial.IRON.func_77996_d(), (int)1323, (float)Item.ToolMaterial.IRON.func_77998_b(), (float)Item.ToolMaterial.IRON.func_78000_c(), (int)Item.ToolMaterial.IRON.func_77995_e());
        harvesterScythe = ((Item)new ItemHarvesterScythe(harvesterMaterial).setRegistryName(new ResourceLocation(MODID, "harvester_scythe"))).func_77655_b("harvestersnight.harvester_scythe").func_77637_a(CreativeTabs.field_78040_i);
        event.getRegistry().register((IForgeRegistryEntry)harvesterScythe);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent evt) {
        ModelLoader.setCustomModelResourceLocation((Item)harvesterScythe, (int)0, (ModelResourceLocation)new ModelResourceLocation(harvesterScythe.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        EntityEntryBuilder builder = EntityEntryBuilder.create().entity(EntityHarvester.class).name("harvestersnight.harvester").id(new ResourceLocation(MODID, "harvester"), 1).tracker(64, 3, true).egg(7753513, 16765192);
        if (HarvestersNightConfig.harvesterWeight > 0) {
            builder.spawn(EnumCreatureType.MONSTER, HarvestersNightConfig.harvesterWeight, 1, 1, (Iterable)ForgeRegistries.BIOMES.getValuesCollection());
        }
        event.getRegistry().register((IForgeRegistryEntry)builder.build());
        LootTableList.func_186375_a((ResourceLocation)EntityHarvester.LOOT);
    }

    @SubscribeEvent
    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry reg = event.getRegistry();
        harvesterCharge = HarvestersNight.registerSoundEvent((IForgeRegistry<SoundEvent>)reg, "harvester.charge");
        harvesterSpell = HarvestersNight.registerSoundEvent((IForgeRegistry<SoundEvent>)reg, "harvester.spell");
        harvesterSpawn = HarvestersNight.registerSoundEvent((IForgeRegistry<SoundEvent>)reg, "harvester.spawn");
        harvesterHurt = HarvestersNight.registerSoundEvent((IForgeRegistry<SoundEvent>)reg, "harvester.hurt");
        harvesterDie = HarvestersNight.registerSoundEvent((IForgeRegistry<SoundEvent>)reg, "harvester.die");
    }

    public static SoundEvent registerSoundEvent(IForgeRegistry<SoundEvent> reg, String name) {
        ResourceLocation location = new ResourceLocation(MODID, name);
        SoundEvent event = (SoundEvent)new SoundEvent(location).setRegistryName(location);
        reg.register((IForgeRegistryEntry)event);
        return event;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
    }
}

