/*
 * Decompiled with CFR 0.152.
 */
package lykrast.harvestersnight.common;

import javax.annotation.Nullable;
import lykrast.harvestersnight.common.HarvestersNight;
import lykrast.harvestersnight.common.HarvestersNightConfig;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class EntityHarvester
extends EntityMob {
    public static final ResourceLocation LOOT = new ResourceLocation("harvestersnight", "entities/harvester");
    protected static final DataParameter<Byte> FLAGS = EntityDataManager.func_187226_a(EntityHarvester.class, (DataSerializer)DataSerializers.field_187191_a);
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.YELLOW, BossInfo.Overlay.PROGRESS);

    public EntityHarvester(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
        this.field_70728_aV = 50;
        this.field_70765_h = new AIMoveControl(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIClawAttack(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLAGS, (Object)0);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
    }

    public void func_70636_d() {
        float f;
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && this.func_70638_az() == null && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            boolean flag = true;
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!itemstack.func_190926_b()) {
                if (itemstack.func_77984_f()) {
                    itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                        this.func_70669_a(itemstack);
                        this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.func_70106_y();
            }
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_190095_e || source == DamageSource.field_76372_a || source == DamageSource.field_76370_b || source == DamageSource.field_76371_c) {
            amount *= 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70601_bi() {
        return ArrayUtils.contains((int[])HarvestersNightConfig.dimList, (int)this.field_70170_p.field_73011_w.getDimension()) == HarvestersNightConfig.whiteList && this.field_70163_u > 40.0 && this.field_70146_Z.nextInt(HarvestersNightConfig.harvesterChance) == 0 && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v)) && super.func_70601_bi();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_180481_a(difficulty);
        if (HarvestersNightConfig.lightning) {
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, true));
        }
        if (HarvestersNightConfig.laugh) {
            this.func_184185_a(HarvestersNight.harvesterSpawn, 8.0f, 1.0f);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(HarvestersNight.harvesterScythe));
        this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        if (HarvestersNightConfig.healthBar) {
            this.bossInfo.func_186760_a(player);
        }
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return !HarvestersNightConfig.isBoss;
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187643_bs;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return HarvestersNight.harvesterHurt;
    }

    protected SoundEvent func_184615_bR() {
        return HarvestersNight.harvesterDie;
    }

    private boolean getHarvesterFlag(int mask) {
        byte i = (Byte)this.field_70180_af.func_187225_a(FLAGS);
        return (i & mask) != 0;
    }

    private void setHarvesterFlag(int mask, boolean value) {
        int i = ((Byte)this.field_70180_af.func_187225_a(FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.field_70180_af.func_187227_b(FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getHarvesterFlag(1);
    }

    public void setCharging(boolean value) {
        this.setHarvesterFlag(1, value);
    }

    public boolean isCasting() {
        return this.getHarvesterFlag(2);
    }

    public void setCasting(boolean value) {
        this.setHarvesterFlag(2, value);
    }

    private static class AIClawAttack
    extends EntityAIBase {
        private EntityHarvester harvester;
        private int time;
        private int phase;

        public AIClawAttack(EntityHarvester harvester) {
            this.func_75248_a(1);
            this.harvester = harvester;
            this.time = 0;
            this.phase = 0;
        }

        public boolean func_75250_a() {
            if (this.harvester.func_70638_az() != null && !this.harvester.func_70605_aq().func_75640_a() && this.harvester.field_70146_Z.nextInt(5) == 0) {
                return this.harvester.func_70068_e((Entity)this.harvester.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.time > 0 && this.harvester.isCasting() && this.harvester.func_70638_az() != null && this.harvester.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            this.harvester.setCasting(true);
            this.harvester.func_184185_a(HarvestersNight.harvesterSpell, 1.0f, 1.0f);
            this.time = 10;
            this.phase = 0;
        }

        public void func_75251_c() {
            this.harvester.setCasting(false);
            this.time = 0;
            this.phase = 0;
        }

        public void func_75246_d() {
            EntityLivingBase target = this.harvester.func_70638_az();
            --this.time;
            if (this.phase == 1 && this.time % 10 == 0 && target != null && target.func_70089_S()) {
                double yMin = target.field_70163_u;
                float f = (float)MathHelper.func_181159_b((double)(target.field_70161_v - this.harvester.field_70161_v), (double)(target.field_70165_t - this.harvester.field_70165_t));
                this.spawnFangs(target.field_70165_t, target.field_70161_v, yMin, target.field_70163_u, f, 0);
            }
            if (this.time <= 0 && this.phase < 3) {
                if (this.phase == 0) {
                    this.time = 60 + this.harvester.field_70146_Z.nextInt(5) * 10;
                } else if (this.phase == 1) {
                    this.time = 30;
                }
                ++this.phase;
            }
            this.harvester.func_70671_ap().func_75651_a((Entity)target, 10.0f, 10.0f);
        }

        private void spawnFangs(double x, double z, double yMin, double yStart, float yaw, int delayTick) {
            BlockPos blockpos = new BlockPos(x, yStart, z);
            boolean flag = false;
            double d0 = 0.0;
            do {
                IBlockState iblockstate;
                AxisAlignedBB axisalignedbb;
                if (this.harvester.field_70170_p.func_175677_d(blockpos, true) || !this.harvester.field_70170_p.func_175677_d(blockpos.func_177977_b(), true)) continue;
                if (!this.harvester.field_70170_p.func_175623_d(blockpos) && (axisalignedbb = (iblockstate = this.harvester.field_70170_p.func_180495_p(blockpos)).func_185890_d((IBlockAccess)this.harvester.field_70170_p, blockpos)) != null) {
                    d0 = axisalignedbb.field_72337_e;
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)yMin));
            EntityEvokerFangs entityevokerfangs = new EntityEvokerFangs(this.harvester.field_70170_p, x, flag ? (double)blockpos.func_177956_o() + d0 : yStart, z, yaw, delayTick, (EntityLivingBase)this.harvester);
            this.harvester.field_70170_p.func_72838_d((Entity)entityevokerfangs);
        }
    }

    private static class AIChargeAttack
    extends EntityAIBase {
        private EntityHarvester harvester;

        public AIChargeAttack(EntityHarvester harvester) {
            this.func_75248_a(1);
            this.harvester = harvester;
        }

        public boolean func_75250_a() {
            if (this.harvester.func_70638_az() != null && !this.harvester.func_70605_aq().func_75640_a() && this.harvester.field_70146_Z.nextInt(4) == 0) {
                return this.harvester.func_70068_e((Entity)this.harvester.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.harvester.func_70605_aq().func_75640_a() && this.harvester.isCharging() && this.harvester.func_70638_az() != null && this.harvester.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = this.harvester.func_70638_az();
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            this.harvester.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            this.harvester.setCharging(true);
            this.harvester.func_184185_a(HarvestersNight.harvesterCharge, 1.0f, 1.0f);
        }

        public void func_75251_c() {
            this.harvester.setCharging(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.harvester.func_70638_az();
            if (this.harvester.func_174813_aQ().func_186662_g(0.5).func_72326_a(entitylivingbase.func_174813_aQ())) {
                this.harvester.func_70652_k((Entity)entitylivingbase);
                this.harvester.setCharging(false);
            } else {
                double d0 = this.harvester.func_70068_e((Entity)entitylivingbase);
                if (d0 < 9.0) {
                    Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                    this.harvester.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b - 1.0, vec3d.field_72449_c, 1.0);
                }
            }
        }
    }

    private static class AIMoveRandom
    extends EntityAIBase {
        private EntityHarvester harvester;

        public AIMoveRandom(EntityHarvester mourner) {
            this.func_75248_a(1);
            this.harvester = mourner;
        }

        public boolean func_75250_a() {
            return !this.harvester.func_70605_aq().func_75640_a() && this.harvester.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = this.harvester.func_70638_az() != null && this.harvester.func_70638_az().func_70089_S() ? new BlockPos((Entity)this.harvester.func_70638_az()) : new BlockPos((Entity)this.harvester);
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(this.harvester.field_70146_Z.nextInt(15) - 7, this.harvester.field_70146_Z.nextInt(11) - 5, this.harvester.field_70146_Z.nextInt(15) - 7);
                if (!this.harvester.field_70170_p.func_175623_d(blockpos1)) continue;
                this.harvester.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (this.harvester.func_70638_az() != null) break;
                this.harvester.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    private static class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityHarvester harvester) {
            super((EntityLiving)harvester);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                double d1 = this.field_75647_c - this.field_75648_a.field_70163_u;
                double d2 = this.field_75644_d - this.field_75648_a.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < this.field_75648_a.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    this.field_75648_a.field_70159_w *= 0.5;
                    this.field_75648_a.field_70181_x *= 0.5;
                    this.field_75648_a.field_70179_y *= 0.5;
                } else {
                    this.field_75648_a.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    this.field_75648_a.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    this.field_75648_a.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (this.field_75648_a.func_70638_az() == null) {
                        this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z = -((float)MathHelper.func_181159_b((double)this.field_75648_a.field_70159_w, (double)this.field_75648_a.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = this.field_75648_a.func_70638_az().field_70165_t - this.field_75648_a.field_70165_t;
                        double d5 = this.field_75648_a.func_70638_az().field_70161_v - this.field_75648_a.field_70161_v;
                        this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

