/*
 * Decompiled with CFR 0.152.
 */
package com.golems.renders;

import com.golems.entity.GolemBase;
import com.golems.renders.ModelGolem;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;

public class RenderGolem<T extends GolemBase>
extends RenderLiving<T> {
    protected static final ResourceLocation fallbackTexture = GolemBase.makeTexture("golems", "golem_clay");
    protected ResourceLocation texture;
    protected static final ResourceLocation[] damageIndicators = new ResourceLocation[]{GolemBase.makeTexture("golems", "damage/damaged_0"), GolemBase.makeTexture("golems", "damage/damaged_1"), GolemBase.makeTexture("golems", "damage/damaged_2")};
    protected static final float DAMAGE_ALPHA = 0.45f;

    public RenderGolem(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelGolem(), 0.5f);
    }

    public void doRender(T golem, double x, double y, double z, float entityYaw, float partialTicks) {
        this.bindGolemTexture(golem);
        super.func_76986_a(golem, x, y, z, entityYaw, partialTicks);
        this.renderDamage(golem, x, y, z, entityYaw, partialTicks);
    }

    protected void bindGolemTexture(T golem) {
        this.texture = ((GolemBase)((Object)golem)).getTextureType();
    }

    protected void applyRotations(T golem, float p_77043_2_, float rotationYaw, float partialTicks) {
        super.func_77043_a(golem, p_77043_2_, rotationYaw, partialTicks);
        if ((double)((GolemBase)((Object)golem)).field_70721_aZ >= 0.01) {
            float f = 13.0f;
            float f1 = ((GolemBase)((Object)golem)).field_184619_aG - ((GolemBase)((Object)golem)).field_70721_aZ * (1.0f - partialTicks) + 6.0f;
            float f2 = (Math.abs(f1 % 13.0f - 6.5f) - 3.25f) / 3.25f;
            GlStateManager.func_179114_b((float)(6.5f * f2), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected void renderDamage(T golem, double x, double y, double z, float entityYaw, float partialTicks) {
        int index = Math.min(this.getDamageTexture(golem), damageIndicators.length - 1);
        if (index > -1) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.45f);
            GlStateManager.func_179108_z();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            this.texture = damageIndicators[index];
            super.func_76986_a(golem, x, y, z, entityYaw, partialTicks);
            GlStateManager.func_179084_k();
            GlStateManager.func_179133_A();
            GlStateManager.func_179121_F();
        }
    }

    protected ResourceLocation getEntityTexture(T golem) {
        return this.texture != null ? this.texture : fallbackTexture;
    }

    protected int getDamageTexture(T golem) {
        float percentHealth = golem.func_110143_aJ() / golem.func_110138_aP();
        return damageIndicators.length - (int)Math.ceil(percentHealth * 4.0f);
    }
}

