/*
 * Decompiled with CFR 0.152.
 */
package com.golems.items;

import com.golems.entity.EntityBedrockGolem;
import com.golems.main.Config;
import com.golems.util.GolemLookup;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ItemBedrockGolem
extends Item {
    public ItemBedrockGolem() {
        this.func_77637_a(CreativeTabs.field_78026_f);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (GolemLookup.getConfig(EntityBedrockGolem.class).canSpawn()) {
            BlockPos spawn;
            if (Config.isBedrockGolemCreativeOnly() && !player.field_71075_bZ.field_75098_d) {
                return EnumActionResult.PASS;
            }
            if (facing == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            boolean flag = worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos);
            BlockPos blockPos = spawn = flag ? pos : pos.func_177972_a(facing);
            if (!worldIn.field_72995_K) {
                EntityBedrockGolem golem = new EntityBedrockGolem(worldIn);
                golem.func_70849_f(true);
                golem.func_174828_a(spawn, 0.0f, 0.0f);
                worldIn.func_72838_d((Entity)golem);
            }
            ItemBedrockGolem.spawnParticles(worldIn, (double)pos.func_177958_n() - 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() - 0.5, 0.2);
            player.func_184609_a(hand);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static void spawnParticles(World world, double x, double y, double z, double motion) {
        ItemBedrockGolem.spawnParticles(world, x, y, z, motion, EnumParticleTypes.SMOKE_LARGE, 60);
    }

    public static void spawnParticles(World world, double x, double y, double z, double motion, EnumParticleTypes type, int num) {
        if (world.field_72995_K) {
            for (int i = num + world.field_73012_v.nextInt(Math.max(1, num / 2)); i > 0; --i) {
                world.func_175688_a(type, x + world.field_73012_v.nextDouble() - 0.5, y + world.field_73012_v.nextDouble() - 0.5, z + world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() * motion - motion * 0.5, world.field_73012_v.nextDouble() * motion * 0.5, world.field_73012_v.nextDouble() * motion - motion * 0.5, new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, World world, List<String> par3List, ITooltipFlag flag) {
        String loreCreativeOnly = TextFormatting.RED + this.trans("tooltip.creative_only_item");
        if (Config.isBedrockGolemCreativeOnly()) {
            par3List.add(loreCreativeOnly);
        }
        if (GuiScreen.func_146272_n()) {
            par3List.add(I18n.func_135052_a((String)"tooltip.use_to_spawn", (Object[])new Object[]{this.trans("entity.golems.golem_bedrock.name")}));
            par3List.add(I18n.func_135052_a((String)"tooltip.use_on_existing", (Object[])new Object[]{this.trans("entity.golems.golem_bedrock.name")}));
            par3List.add(this.trans("tooltip.to_remove_it") + ".");
        } else {
            String lorePressShift = TextFormatting.GRAY + this.trans("tooltip.press") + " " + TextFormatting.YELLOW + this.trans("tooltip.shift").toUpperCase() + " " + TextFormatting.GRAY + this.trans("tooltip.for_more_details");
            par3List.add(lorePressShift);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private String trans(String s) {
        return I18n.func_135052_a((String)s, (Object[])new Object[0]);
    }
}

