/*
 * Decompiled with CFR 0.152.
 */
package com.golems.integration.waila;

import com.golems.entity.GolemBase;
import com.golems.integration.GolemDescriptionManager;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="mcp.mobius.waila.api.IWailaEntityProvider", modid="waila")
public final class WailaExtraGolems
extends GolemDescriptionManager
implements IWailaEntityProvider {
    public static final String CONFIG_SHOW_ATTACK_DAMAGE = "extragolems.show_attack_damage_tip";
    public static final String CONFIG_SHOW_SPECIAL_ABILITIES = "extragolems.show_special_abilities_tip";
    public static final String CONFIG_SHOW_KNOCKBACK_RESIST = "extragolems.show_knockback_resistance_tip";
    public static final String CONFIG_SHOW_MULTI_TEXTURE = "extragolems.show_multitexture_tip";
    public static final String CONFIG_SHOW_FIREPROOF = "extragolems.show_fireproof_tip";
    public static final String CONFIG_SHOW_HEAL_ITEM = "extragolems.show_heal_item_tip";

    @Optional.Method(modid="waila")
    public static void callbackRegister(IWailaRegistrar register) {
        WailaExtraGolems instance = new WailaExtraGolems();
        register.registerBodyProvider((IWailaEntityProvider)instance, GolemBase.class);
        String EXTRA_GOLEMS = "Extra-Golems";
        register.addConfig("Extra-Golems", CONFIG_SHOW_ATTACK_DAMAGE, true);
        register.addConfig("Extra-Golems", CONFIG_SHOW_SPECIAL_ABILITIES, true);
        register.addConfig("Extra-Golems", CONFIG_SHOW_KNOCKBACK_RESIST, false);
        register.addConfig("Extra-Golems", CONFIG_SHOW_MULTI_TEXTURE, true);
        register.addConfig("Extra-Golems", CONFIG_SHOW_FIREPROOF, true);
        register.addConfig("Extra-Golems", CONFIG_SHOW_HEAL_ITEM, true);
    }

    @Optional.Method(modid="waila")
    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity entity, NBTTagCompound tag, World world) {
        NBTTagCompound tag2 = new NBTTagCompound();
        entity.func_189511_e(tag2);
        return tag2;
    }

    @Optional.Method(modid="waila")
    @Nonnull
    public List<String> getWailaBody(Entity entity, List<String> tip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (entity instanceof GolemBase) {
            GolemBase golem = (GolemBase)entity;
            this.showAttack = config.getConfig(CONFIG_SHOW_ATTACK_DAMAGE) && accessor.getPlayer().func_70093_af();
            this.showMultiTexture = config.getConfig(CONFIG_SHOW_MULTI_TEXTURE);
            this.showSpecial = config.getConfig(CONFIG_SHOW_SPECIAL_ABILITIES);
            this.showFireproof = config.getConfig(CONFIG_SHOW_FIREPROOF) && accessor.getPlayer().func_70093_af();
            this.showKnockbackResist = config.getConfig(CONFIG_SHOW_KNOCKBACK_RESIST);
            this.showHealItems = config.getConfig(CONFIG_SHOW_HEAL_ITEM) && accessor.getPlayer().func_70093_af();
            tip.addAll(this.getEntityDescription(golem));
        }
        return tip;
    }

    @Optional.Method(modid="waila")
    @Nonnull
    public List<String> getWailaHead(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Optional.Method(modid="waila")
    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return accessor.getEntity();
    }

    @Optional.Method(modid="waila")
    @Nonnull
    public List<String> getWailaTail(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }
}

