/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity.ai;

import com.golems.entity.GolemBase;
import java.util.function.BiPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class EntityAIUtilityBlock
extends EntityAIBase {
    public final GolemBase golem;
    public final IBlockState stateToPlace;
    public final int tickDelay;
    public final boolean configAllows;
    public final BiPredicate<GolemBase, IBlockState> predicate;

    public EntityAIUtilityBlock(GolemBase golemIn, IBlockState stateIn, int interval, boolean cfgAllows, BiPredicate<GolemBase, IBlockState> canReplacePred) {
        this.func_75248_a(8);
        this.golem = golemIn;
        this.stateToPlace = stateIn;
        this.tickDelay = interval;
        this.configAllows = cfgAllows;
        this.predicate = canReplacePred;
    }

    public EntityAIUtilityBlock(GolemBase golemIn, IBlockState stateIn, int interval, boolean configAllows) {
        this(golemIn, stateIn, interval, configAllows, EntityAIUtilityBlock.getDefaultBiPred(stateIn));
    }

    public boolean func_75250_a() {
        return this.configAllows;
    }

    public void func_75246_d() {
        long tickMod = this.golem.field_70173_aa % this.tickDelay;
        if (this.configAllows && tickMod == 0L) {
            int x = MathHelper.func_76128_c((double)this.golem.field_70165_t);
            int y = MathHelper.func_76128_c((double)(this.golem.field_70163_u - (double)0.2f - this.golem.func_70033_W()));
            int z = MathHelper.func_76128_c((double)this.golem.field_70161_v);
            BlockPos blockPosIn = new BlockPos(x, y, z);
            for (int i = 0; i < 3; ++i) {
                BlockPos temp = blockPosIn.func_177981_b(i);
                IBlockState cur = this.golem.func_130014_f_().func_180495_p(temp);
                if (cur.func_177230_c() == this.stateToPlace.func_177230_c()) {
                    return;
                }
                if (!this.predicate.test(this.golem, cur)) continue;
                this.golem.func_130014_f_().func_180501_a(temp, this.getStateToPlace(cur), 6);
                return;
            }
        }
    }

    public void func_75249_e() {
        this.func_75246_d();
    }

    public static BiPredicate<GolemBase, IBlockState> getDefaultBiPred(IBlockState stateIn) {
        return (golem, toReplace) -> toReplace.func_177230_c() == Blocks.field_150350_a;
    }

    protected IBlockState getStateToPlace(IBlockState toReplace) {
        return this.stateToPlace;
    }
}

