/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class GolemColorized
extends GolemBase {
    private long color;
    protected float colorRed;
    protected float colorBlue;
    protected float colorGreen;
    protected float colorAlpha;
    protected final ResourceLocation base;
    protected final ResourceLocation overlay;
    protected final boolean hasBase;

    public GolemColorized(World world, long initial, @Nullable ResourceLocation rBase, @Nullable ResourceLocation rOverlay) {
        super(world);
        this.setColor(initial);
        this.base = rBase;
        this.overlay = rOverlay;
        this.hasBase = this.base != null;
    }

    @Override
    protected ResourceLocation applyTexture() {
        return GolemColorized.makeTexture("golems", "golem_clay");
    }

    public ResourceLocation getTextureBase() {
        return this.base;
    }

    public ResourceLocation getTextureToColor() {
        return this.overlay;
    }

    public boolean hasBase() {
        return this.hasBase;
    }

    public void setColor(long toSet) {
        this.color = toSet;
        long tmpColor = toSet;
        if ((tmpColor & 0xFFFFFFFFFC000000L) == 0L) {
            tmpColor |= 0xFFFFFFFFFF000000L;
        }
        this.colorRed = (float)(tmpColor >> 16 & 0xFFL) / 255.0f;
        this.colorGreen = (float)(tmpColor >> 8 & 0xFFL) / 255.0f;
        this.colorBlue = (float)(tmpColor & 0xFFL) / 255.0f;
        this.colorAlpha = (float)(tmpColor >> 24 & 0xFFL) / 255.0f;
    }

    public long getColor() {
        return this.color;
    }

    public float getColorRed() {
        return this.colorRed;
    }

    public float getColorGreen() {
        return this.colorGreen;
    }

    public float getColorBlue() {
        return this.colorBlue;
    }

    public float getColorAlpha() {
        return this.colorAlpha;
    }

    public boolean hasTransparency() {
        return false;
    }
}

