/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemColorizedMultiTextured;
import com.golems.entity.GolemMultiTextured;
import com.golems.items.ItemBedrockGolem;
import com.golems.main.Config;
import com.golems.util.GolemConfigSet;
import com.golems.util.GolemLookup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public abstract class GolemBase
extends EntityIronGolem {
    private static final DataParameter<Boolean> CHILD = EntityDataManager.func_187226_a(GolemBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final String KEY_CHILD = "isChild";
    public static final int WANDER_DISTANCE = 64;
    protected Map<ItemStack, Double> healItemMap = new HashMap<ItemStack, Double>();
    protected ResourceLocation textureLoc;
    protected ResourceLocation lootTableLoc;
    protected double knockbackY = 0.4f;
    protected float criticalModifier = 2.25f;
    protected int criticalChance = 5;
    protected boolean takesFallDamage = false;
    protected boolean canDrown = false;
    protected EntityAIBase swimmingAI = new EntityAISwimming((EntityLiving)this);
    protected EntityAIBase wanderAvoidWater = null;
    protected EntityAIBase wander = null;

    public GolemBase(World world) {
        super(world);
        this.func_70105_a(1.4f, 2.9f);
        this.setCanTakeFallDamage(false);
        this.setCanSwim(false);
        GolemConfigSet cfg = GolemBase.getConfig(this);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)cfg.getBaseAttack());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(cfg.getMaxHealth());
        this.field_70728_aV = 4 + this.field_70146_Z.nextInt(8);
        for (Block b : GolemBase.getBuildingBlocks(this)) {
            Item i = Item.func_150898_a((Block)b);
            if (i == Items.field_190931_a) continue;
            this.healItemMap.put(new ItemStack(i), 0.75);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.setTextureType(this.applyTexture());
        this.func_184212_Q().func_187214_a(CHILD, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        GolemConfigSet cfg = GolemBase.getConfig(this);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a((double)cfg.getBaseAttack());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(cfg.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        if (this.func_70850_q() && EntityPlayer.class.isAssignableFrom(cls)) {
            return Config.enableFriendlyFire();
        }
        if (EntityVillager.class.isAssignableFrom(cls) || GolemBase.class.isAssignableFrom(cls)) {
            return false;
        }
        return super.func_70686_a(cls);
    }

    public boolean func_70652_k(Entity entity) {
        float currentAttack = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float damage = currentAttack + (float)(this.field_70146_Z.nextDouble() - 0.5) * 0.75f * currentAttack;
        if (this.field_70146_Z.nextInt(100) < this.criticalChance) {
            damage *= this.criticalModifier;
        }
        ReflectionHelper.setPrivateValue(EntityIronGolem.class, (Object)((Object)this), (Object)10, (String[])new String[]{"field_70855_f", "attackTimer"});
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
        if (flag) {
            entity.field_70181_x += this.knockbackY;
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        this.func_184185_a(this.getThrowSound(), 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
        return flag;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.canTakeFallDamage()) {
            return;
        }
        float[] ret = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        super.func_180430_e(distance, damageMultiplier);
        PotionEffect potioneffect = this.func_70660_b(MobEffects.field_76430_j);
        float f = potioneffect == null ? 0.0f : (float)(potioneffect.func_76458_c() + 1);
        int i = MathHelper.func_76123_f((float)((distance - 3.0f - f) * damageMultiplier));
        if (i > 0) {
            this.func_184185_a(this.func_184588_d(i), 1.0f, 1.0f);
            this.func_70097_a(DamageSource.field_76379_h, i);
            int j = MathHelper.func_76128_c((double)this.field_70165_t);
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int l = MathHelper.func_76128_c((double)this.field_70161_v);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(j, k, l));
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                SoundType soundtype = iblockstate.func_177230_c().getSoundType(iblockstate, this.field_70170_p, new BlockPos(j, k, l), (Entity)this);
                this.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    public int func_82143_as() {
        return this.canTakeFallDamage() ? super.func_82143_as() : 64;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(this.getWalkingSound(), 0.76f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        Block pickBlock = GolemLookup.getFirstBuildingBlock(((Object)((Object)this)).getClass());
        return pickBlock != null ? new ItemStack(pickBlock) : ItemStack.field_190927_a;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a(KEY_CHILD, this.func_70631_g_());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setChild(compound.func_74767_n(KEY_CHILD));
    }

    protected ResourceLocation func_184647_J() {
        return this.lootTableLoc;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        float addHealth;
        ItemStack stack = player.func_184586_b(hand);
        float f = addHealth = Config.enableHealGolems() ? this.getHealAmount(stack) : 0.0f;
        if (addHealth > 0.0f && this.func_110143_aJ() < this.func_110138_aP() && !player.func_70093_af()) {
            this.func_70691_i(addHealth);
            stack.func_190918_g(1);
            if (this.func_70638_az() == player) {
                this.func_70604_c(null);
                this.func_70624_b(null);
            }
            if (this.field_70170_p.field_72995_K) {
                ItemBedrockGolem.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, 0.12, EnumParticleTypes.VILLAGER_HAPPY, 20);
            }
            this.func_184185_a(SoundEvents.field_187845_fY, 0.85f, 1.1f + this.field_70146_Z.nextFloat() * 0.2f);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void onBuilt(IBlockState body, IBlockState legs, IBlockState arm1, IBlockState arm2) {
    }

    public void setLootTableLoc(ResourceLocation lootTable) {
        this.lootTableLoc = lootTable;
    }

    public void setLootTableLoc(String modid, String name) {
        this.lootTableLoc = new ResourceLocation(modid, "entities/" + name);
    }

    public void setLootTableLoc(String name) {
        this.setLootTableLoc("golems", name);
    }

    public void setTextureType(ResourceLocation texturelocation) {
        this.textureLoc = texturelocation;
    }

    public ResourceLocation getTextureType() {
        return this.textureLoc;
    }

    public void setChild(boolean isChild) {
        this.func_184212_Q().func_187227_b(CHILD, (Object)isChild);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(CHILD);
    }

    public void setCanTakeFallDamage(boolean toSet) {
        this.takesFallDamage = toSet;
    }

    public boolean canTakeFallDamage() {
        return this.takesFallDamage;
    }

    public void setCanSwim(boolean canSwim) {
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(canSwim);
        if (null == this.wander) {
            this.wander = new EntityAIWander((EntityCreature)this, 0.8);
        }
        if (null == this.wanderAvoidWater) {
            this.wanderAvoidWater = new EntityAIWanderAvoidWater((EntityCreature)this, 0.8);
        }
        if (canSwim) {
            this.field_70714_bg.func_75776_a(0, this.swimmingAI);
            this.field_70714_bg.func_75776_a(5, this.wander);
            this.field_70714_bg.func_85156_a(this.wanderAvoidWater);
        } else {
            this.field_70714_bg.func_85156_a(this.swimmingAI);
            this.field_70714_bg.func_85156_a(this.wander);
            this.field_70714_bg.func_75776_a(5, this.wanderAvoidWater);
        }
    }

    public void setImmuneToFire(boolean toSet) {
        this.field_70178_ae = toSet;
    }

    public GolemBase addHealItem(ItemStack s, double multiplier) {
        this.healItemMap.put(s, multiplier);
        return this;
    }

    public Set<ItemStack> getHealItems() {
        return this.healItemMap.keySet();
    }

    public boolean doesInteractChangeTexture() {
        return Config.interactChangesTexture() && (GolemMultiTextured.class.isAssignableFrom(((Object)((Object)this)).getClass()) || GolemColorizedMultiTextured.class.isAssignableFrom(((Object)((Object)this)).getClass()));
    }

    public boolean isProvidingLight() {
        return false;
    }

    public boolean isProvidingPower() {
        return false;
    }

    @Nullable
    public static Block[] getBuildingBlocks(GolemBase golem) {
        return GolemLookup.getBuildingBlocks(((Object)((Object)golem)).getClass());
    }

    @Nonnull
    public static GolemConfigSet getConfig(GolemBase golem) {
        return golem != null && GolemLookup.hasConfig(((Object)((Object)golem)).getClass()) ? GolemLookup.getConfig(((Object)((Object)golem)).getClass()) : GolemConfigSet.EMPTY;
    }

    public float getHealAmount(ItemStack i) {
        if (i != null && !i.func_190926_b()) {
            for (Map.Entry<ItemStack, Double> e : this.healItemMap.entrySet()) {
                boolean metaMatches;
                boolean itemMatches = e.getKey().func_77973_b() == i.func_77973_b();
                boolean bl = metaMatches = e.getKey().func_77960_j() == Short.MAX_VALUE || e.getKey().func_77960_j() == i.func_77960_j();
                if (!itemMatches || !metaMatches) continue;
                double h = (double)this.func_110138_aP() * e.getValue();
                if (this.func_70631_g_()) {
                    h *= 1.75;
                }
                return Math.min((float)h, 32.0f);
            }
        }
        return 0.0f;
    }

    protected static String trans(String s, Object ... strings) {
        return new TextComponentTranslation(s, strings).func_150254_d();
    }

    public static ResourceLocation makeTexture(String MODID, String TEXTURE) {
        return new ResourceLocation(MODID + ":textures/entity/" + TEXTURE + ".png");
    }

    protected SoundEvent func_184639_G() {
        return this.getGolemSound();
    }

    protected SoundEvent getWalkingSound() {
        return this.getGolemSound();
    }

    public SoundEvent getThrowSound() {
        return this.getGolemSound();
    }

    protected SoundEvent func_184601_bQ(DamageSource ignored) {
        return this.getGolemSound();
    }

    protected SoundEvent func_184615_bR() {
        return this.getGolemSound();
    }

    public List<String> addSpecialDesc(List<String> list) {
        return list;
    }

    protected abstract ResourceLocation applyTexture();

    public abstract SoundEvent getGolemSound();
}

