/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemMultiTextured;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public final class EntityWoodenGolem
extends GolemMultiTextured {
    public static final String WOOD_PREFIX = "wooden";
    public static final String[] woodTypes = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "big_oak"};

    public EntityWoodenGolem(World world) {
        super(world, WOOD_PREFIX, woodTypes);
        this.setCanSwim(true);
        this.addHealItem(new ItemStack(Blocks.field_150364_r, 1, Short.MAX_VALUE), 0.75);
        this.addHealItem(new ItemStack(Blocks.field_150363_s, 1, Short.MAX_VALUE), 0.75);
        this.addHealItem(new ItemStack(Blocks.field_150344_f), 0.25);
        this.addHealItem(new ItemStack(Items.field_151055_y), 0.1);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public ItemStack getPickedResult(RayTraceResult target) {
        Block block = Blocks.field_150364_r;
        int damage = this.getTextureNum() % woodTypes.length;
        if (this.getTextureNum() > 3) {
            block = Blocks.field_150363_s;
            damage %= 2;
        }
        return new ItemStack(block, 1, damage);
    }

    @Override
    public String getModId() {
        return "golems";
    }

    @Override
    public void onBuilt(IBlockState body, IBlockState legs, IBlockState arm1, IBlockState arm2) {
        if (body.func_177230_c() instanceof BlockNewLog || body.func_177230_c() instanceof BlockOldLog) {
            int meta = body.func_177230_c().func_176201_c(body.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE));
            byte textureNum = body.func_177230_c() == Blocks.field_150363_s ? (byte)(meta + 4) : (byte)meta;
            textureNum = (byte)(textureNum % this.getNumTextures());
            this.setTextureNum(textureNum);
        }
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187897_gY;
    }
}

