/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.events.SpongeGolemSoakEvent;
import com.golems.util.GolemConfigSet;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class EntitySpongeGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Absorb Water";
    public static final String INTERVAL = "Water Soaking Frequency";
    public static final String RANGE = "Water Soaking Range";
    public static final String PARTICLES = "Can Render Sponge Particles";

    public EntitySpongeGolem(World world) {
        super(world);
        this.setCanSwim(true);
        this.setLootTableLoc("golem_sponge");
        this.addHealItem(new ItemStack(Blocks.field_150360_v, 1, 1), 0.75);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntitySpongeGolem.makeTexture("golems", "golem_sponge");
    }

    public void func_70636_d() {
        int z;
        int y;
        int x;
        BlockPos center;
        SpongeGolemSoakEvent event;
        super.func_70636_d();
        GolemConfigSet cfg = EntitySpongeGolem.getConfig(this);
        int interval = cfg.getInt(INTERVAL);
        if (cfg.getBoolean(ALLOW_SPECIAL) && (interval <= 1 || this.field_70173_aa % interval == 0) && !MinecraftForge.EVENT_BUS.post((Event)(event = new SpongeGolemSoakEvent(this, center = new BlockPos(x = MathHelper.func_76128_c((double)this.field_70165_t), y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)) + 2, z = MathHelper.func_76128_c((double)this.field_70161_v)), cfg.getInt(RANGE)))) && event.getResult() != Event.Result.DENY) {
            this.replaceWater(event.getPositionList(), event.getReplacementState(), event.updateFlag);
        }
        if (cfg.getBoolean(PARTICLES) && Math.abs(this.field_70159_w) < 0.05 && Math.abs(this.field_70179_y) < 0.05 && this.field_70170_p.field_72995_K) {
            EnumParticleTypes particle = this.func_70027_ad() ? EnumParticleTypes.SMOKE_NORMAL : EnumParticleTypes.WATER_SPLASH;
            double x2 = this.field_70146_Z.nextDouble() - 0.5 * (double)this.field_70130_N * 0.6;
            double y2 = this.field_70146_Z.nextDouble() * ((double)this.field_70131_O - 0.75);
            double z2 = this.field_70146_Z.nextDouble() - 0.5 * (double)this.field_70130_N;
            this.field_70170_p.func_175688_a(particle, this.field_70165_t + x2, this.field_70163_u + y2, this.field_70161_v + z2, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, this.field_70146_Z.nextDouble() - 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, new int[0]);
        }
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187554_ai;
    }

    public boolean replaceWater(List<BlockPos> positions, IBlockState replaceWater, int updateFlag) {
        boolean flag = true;
        for (BlockPos p : positions) {
            flag &= this.field_70170_p.func_180501_a(p, replaceWater, updateFlag);
        }
        return flag;
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (EntitySpongeGolem.getConfig(this).getBoolean(ALLOW_SPECIAL)) {
            list.add(TextFormatting.YELLOW + EntitySpongeGolem.trans("entitytip.absorbs_water", new Object[0]));
        }
        return list;
    }
}

