/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.blocks.BlockUtilityGlow;
import com.golems.entity.GolemBase;
import com.golems.entity.ai.EntityAIUtilityBlock;
import com.golems.main.GolemItems;
import com.golems.util.GolemConfigSet;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class EntitySeaLanternGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Emit Light";
    public static final String FREQUENCY = "Light Frequency";
    public static final BiPredicate<GolemBase, IBlockState> WATER_PRED = (golem, toReplace) -> toReplace.func_177230_c() != GolemItems.blockLightSourceWater && toReplace.func_185904_a() == Material.field_151586_h && (Integer)toReplace.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
    private static final float BRIGHTNESS = 1.0f;
    private static final int BRIGHTNESS_INT = 15;

    public EntitySeaLanternGolem(World world) {
        super(world);
        this.canDrown = false;
        this.addHealItem(new ItemStack(Items.field_179563_cD), 0.25);
        this.addHealItem(new ItemStack(Items.field_179562_cC), 0.25);
        this.setLootTableLoc("golem_sea_lantern");
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        GolemConfigSet cfg = EntitySeaLanternGolem.getConfig(this);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIUtilityBlock(this, GolemItems.blockLightSourceWater.func_176223_P().func_177226_a((IProperty)BlockUtilityGlow.LIGHT_LEVEL, (Comparable)Integer.valueOf(15)), cfg.getInt(FREQUENCY), cfg.getBoolean(ALLOW_SPECIAL), WATER_PRED));
        this.field_70715_bh.func_75776_a(8, (EntityAIBase)new EntityAIUtilityBlock(this, GolemItems.blockLightSource.func_176223_P().func_177226_a((IProperty)BlockUtilityGlow.LIGHT_LEVEL, (Comparable)Integer.valueOf(15)), cfg.getInt(FREQUENCY), cfg.getBoolean(ALLOW_SPECIAL)));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70090_H()) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 20, 2, false, false));
        }
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntitySeaLanternGolem.makeTexture("golems", "golem_sea_lantern");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187569_bQ;
    }

    @Override
    public boolean isProvidingLight() {
        return true;
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (EntitySeaLanternGolem.getConfig(this).getBoolean(ALLOW_SPECIAL)) {
            list.add(TextFormatting.GOLD + EntitySeaLanternGolem.trans("entitytip.lights_area", new Object[0]));
        }
        list.add(TextFormatting.AQUA + EntitySeaLanternGolem.trans("entitytip.breathes_underwater", new Object[0]));
        return list;
    }
}

