/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.blocks.BlockUtilityGlow;
import com.golems.entity.GolemBase;
import com.golems.entity.GolemMultiTextured;
import com.golems.entity.ai.EntityAIUtilityBlock;
import com.golems.main.GolemItems;
import com.golems.util.GolemConfigSet;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class EntityRedstoneLampGolem
extends GolemMultiTextured {
    public static final String ALLOW_SPECIAL = "Allow Special: Emit Light";
    public static final String FREQUENCY = "Light Frequency";
    public static final String LAMP_PREFIX = "redstone_lamp";
    public static final String[] VARIANTS = new String[]{"lit", "unlit"};
    public static final BiPredicate<GolemBase, IBlockState> LIT_PRED = (golem, toReplace) -> golem.isProvidingLight();

    public EntityRedstoneLampGolem(World world) {
        super(world, LAMP_PREFIX, VARIANTS);
        this.setCanTakeFallDamage(true);
        this.addHealItem(new ItemStack(Items.field_151137_ax), 0.25);
        this.addHealItem(new ItemStack(Items.field_151114_aO), 0.25);
        GolemConfigSet cfg = EntityRedstoneLampGolem.getConfig(this);
        IBlockState state = GolemItems.blockLightSource.func_176223_P().func_177226_a((IProperty)BlockUtilityGlow.LIGHT_LEVEL, (Comparable)Integer.valueOf(15));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIUtilityBlock(this, state, cfg.getInt(FREQUENCY), cfg.getBoolean(ALLOW_SPECIAL), EntityAIUtilityBlock.getDefaultBiPred(state).and(LIT_PRED)));
    }

    @Override
    public boolean doesInteractChangeTexture() {
        return true;
    }

    @Override
    public boolean isProvidingLight() {
        return this.getTextureNum() == 0;
    }

    @Override
    public String getModId() {
        return "golems";
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187569_bQ;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187561_bM;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return this.isProvidingLight() ? 0xF000F0 : super.func_70070_b();
    }

    public float func_70013_c() {
        return this.isProvidingLight() ? 1.0f : super.func_70013_c();
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (EntityRedstoneLampGolem.getConfig(this).getBoolean(ALLOW_SPECIAL)) {
            list.add(TextFormatting.GOLD + EntityRedstoneLampGolem.trans("entitytip.lights_area_toggle", new Object[0]));
        }
        return list;
    }
}

