/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.util.GolemConfigSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public final class EntityNetherBrickGolem
extends GolemBase {
    public static final String ALLOW_FIRE_SPECIAL = "Allow Special: Burn Enemies";

    public EntityNetherBrickGolem(World world) {
        super(world);
        this.setImmuneToFire(true);
        this.setLootTableLoc("golem_nether_brick");
        this.addHealItem(new ItemStack(Items.field_151130_bT), 0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityNetherBrickGolem.makeTexture("golems", "golem_nether_brick");
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            GolemConfigSet cfg = EntityNetherBrickGolem.getConfig(this);
            if (cfg.getBoolean(ALLOW_FIRE_SPECIAL)) {
                entity.func_70015_d(2 + this.field_70146_Z.nextInt(5));
            }
            return true;
        }
        return false;
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (EntityNetherBrickGolem.getConfig(this).getBoolean(ALLOW_FIRE_SPECIAL)) {
            list.add(TextFormatting.RED + EntityNetherBrickGolem.trans("entitytip.lights_mobs_on_fire", new Object[0]));
        }
        return list;
    }
}

