/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.GolemMultiTextured;
import com.golems.entity.ai.EntityAIPlaceRandomBlocksStrictly;
import com.golems.util.GolemConfigSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public final class EntityMushroomGolem
extends GolemMultiTextured {
    public static final String ALLOW_SPECIAL = "Allow Special: Plant Mushrooms";
    public static final String FREQUENCY = "Mushroom Frequency";
    public static final String ALLOW_HEALING = "Allow Special: Random Healing";
    public static final String SHROOM_PREFIX = "shroom";
    public static final String[] SHROOM_TYPES = new String[]{"red", "brown"};

    public EntityMushroomGolem(World world) {
        super(world, SHROOM_PREFIX, SHROOM_TYPES);
        this.setCanSwim(true);
        this.addHealItem(new ItemStack((Block)Blocks.field_150338_P), 0.25);
        this.addHealItem(new ItemStack((Block)Blocks.field_150337_Q), 0.25);
        GolemConfigSet cfg = EntityMushroomGolem.getConfig(this);
        boolean allowed = cfg.getBoolean(ALLOW_SPECIAL);
        int freq = allowed ? cfg.getInt(FREQUENCY) : -100;
        freq += this.field_70146_Z.nextInt(Math.max(10, freq / 2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPlaceRandomBlocksStrictly((GolemBase)this, freq, new IBlockState[]{Blocks.field_150338_P.func_176223_P(), Blocks.field_150337_Q.func_176223_P()}, new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150391_bh, Blocks.field_150351_n}, allowed));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public String getModId() {
        return "golems";
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187579_bV;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().func_72935_r() && this.field_70146_Z.nextInt(450) == 0 && EntityMushroomGolem.getConfig(this).getBoolean(ALLOW_HEALING)) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 20, 2));
        }
    }

    @Override
    public void onBuilt(IBlockState body, IBlockState legs, IBlockState arm1, IBlockState arm2) {
        byte textureNum = body.func_177230_c() == Blocks.field_150419_aX ? (byte)0 : 1;
        textureNum = (byte)(textureNum % this.getNumTextures());
        this.setTextureNum(textureNum);
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (EntityMushroomGolem.getConfig(this).getBoolean(ALLOW_SPECIAL)) {
            list.add(TextFormatting.DARK_GREEN + EntityMushroomGolem.trans("entitytip.plants_shrooms", new Object[0]));
        }
        if (EntityMushroomGolem.getConfig(this).getBoolean(ALLOW_HEALING)) {
            String sHeals = TextFormatting.LIGHT_PURPLE + EntityMushroomGolem.trans("entitytip.heals", new Object[0]);
            list.add(sHeals);
        }
        return list;
    }
}

