/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.GolemColorizedMultiTextured;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public final class EntityConcreteGolem
extends GolemColorizedMultiTextured {
    public static final String ALLOW_RESIST = "Allow Special: Resistance";
    public static final String PREFIX = "concrete";
    public static final int[] COLOR_ARRAY = ItemDye.field_150922_c;
    private static final ResourceLocation TEXTURE_BASE = GolemBase.makeTexture("golems", "golem_concrete_base");
    private static final ResourceLocation TEXTURE_OVERLAY = GolemBase.makeTexture("golems", "golem_concrete_grayscale");

    public EntityConcreteGolem(World world) {
        super(world, TEXTURE_BASE, TEXTURE_OVERLAY, COLOR_ARRAY);
        this.addHealItem(new ItemStack(Blocks.field_192443_dR, 1, Short.MAX_VALUE), 0.75);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (EntityConcreteGolem.getConfig(this).getBoolean(ALLOW_RESIST)) {
            amount *= 0.6f;
        }
        super.func_70665_d(source, amount);
    }

    @Override
    public void onBuilt(IBlockState body, IBlockState legs, IBlockState arm1, IBlockState arm2) {
        int meta = body.func_177230_c().func_176201_c(body) % this.getColorArray().length;
        this.setTextureNum((byte)(this.getColorArray().length - meta - 1));
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (EntityConcreteGolem.getConfig(this).getBoolean(ALLOW_RESIST)) {
            String sResist = TextFormatting.DARK_GRAY + EntityConcreteGolem.trans("effect.resistance", new Object[0]);
            list.add(sResist);
        }
        return list;
    }
}

