/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.util.GolemConfigSet;
import java.util.List;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public final class EntityBookshelfGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Potion Effects";
    private static final Potion[] goodEffects = new Potion[]{MobEffects.field_76426_n, MobEffects.field_76428_l, MobEffects.field_76420_g, MobEffects.field_76444_x, MobEffects.field_188425_z, MobEffects.field_76432_h, MobEffects.field_76429_m, MobEffects.field_76441_p, MobEffects.field_76424_c, MobEffects.field_76430_j};

    public EntityBookshelfGolem(World world) {
        super(world);
        this.setLootTableLoc("golem_bookshelf");
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
        this.addHealItem(new ItemStack(Items.field_151122_aG), 0.25);
        this.addHealItem(new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE), 0.25);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityBookshelfGolem.makeTexture("golems", "golem_bookshelf");
    }

    public void func_70636_d() {
        super.func_70636_d();
        GolemConfigSet cfg = EntityBookshelfGolem.getConfig(this);
        if (cfg.getBoolean(ALLOW_SPECIAL) && this.func_70651_bq().isEmpty() && this.field_70146_Z.nextInt(40) == 0) {
            Potion potion = goodEffects[this.field_70146_Z.nextInt(goodEffects.length)];
            int len = potion.func_76403_b() ? 1 : 200 + 100 * (1 + this.field_70146_Z.nextInt(5));
            this.func_70690_d(new PotionEffect(potion, len, this.field_70146_Z.nextInt(2)));
        }
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187897_gY;
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (EntityBookshelfGolem.getConfig(this).getBoolean(ALLOW_SPECIAL)) {
            list.add(TextFormatting.LIGHT_PURPLE + EntityBookshelfGolem.trans("entitytip.grants_self_potion_effects", new Object[0]));
        }
        return list;
    }
}

