/*
 * Decompiled with CFR 0.152.
 */
package com.golems.blocks;

import com.golems.entity.GolemBase;
import com.golems.items.ItemBedrockGolem;
import com.golems.main.ExtraGolems;
import com.golems.util.GolemConfigSet;
import com.golems.util.GolemLookup;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class BlockGolemHead
extends BlockHorizontal {
    public BlockGolemHead() {
        super(Material.field_151578_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Deprecated
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D});
    }

    @Deprecated
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    @Deprecated
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        BlockGolemHead.trySpawnGolem(world, pos);
    }

    public static boolean trySpawnGolem(World world, BlockPos pos) {
        IBlockState stateBelow1 = world.func_180495_p(pos.func_177979_c(1));
        IBlockState stateBelow2 = world.func_180495_p(pos.func_177979_c(2));
        Block blockBelow1 = stateBelow1.func_177230_c();
        Block blockBelow2 = stateBelow2.func_177230_c();
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() - 1.95;
        double z = (double)pos.func_177952_p() + 0.5;
        if (blockBelow1 == blockBelow2 && blockBelow1 != Blocks.field_150350_a) {
            if (blockBelow1 == Blocks.field_150433_aE) {
                if (!world.field_72995_K) {
                    BlockGolemHead.removeGolemBody(world, pos);
                    EntitySnowman entitysnowman = new EntitySnowman(world);
                    ExtraGolems.LOGGER.info("[Extra Golems]: Building regular boring Snow Golem");
                    entitysnowman.func_70012_b(x, y, z, 0.0f, 0.0f);
                    world.func_72838_d((Entity)entitysnowman);
                }
                ItemBedrockGolem.spawnParticles(world, x, y + 0.5, z, 0.2);
                return true;
            }
            boolean flagX = BlockGolemHead.isGolemXAligned(world, pos);
            boolean flagZ = BlockGolemHead.isGolemZAligned(world, pos);
            if (!world.field_72995_K && (flagX || flagZ)) {
                EnumFacing face = flagX ? EnumFacing.EAST : EnumFacing.NORTH;
                IBlockState arm1 = world.func_180495_p(pos.func_177979_c(1).func_177967_a(face, 1));
                IBlockState arm2 = world.func_180495_p(pos.func_177979_c(1).func_177967_a(face.func_176734_d(), 1));
                if (blockBelow1 == Blocks.field_150339_S) {
                    BlockGolemHead.removeAllGolemBlocks(world, pos, flagX);
                    EntityIronGolem golem = new EntityIronGolem(world);
                    ExtraGolems.LOGGER.info("[Extra Golems]: Building regular boring Iron Golem");
                    golem.func_70849_f(true);
                    golem.func_70012_b(x, y, z, 0.0f, 0.0f);
                    world.func_72838_d((Entity)golem);
                    return true;
                }
                if (GolemLookup.isBuildingBlock(blockBelow1)) {
                    boolean allowed;
                    GolemBase golem = GolemLookup.getGolem(world, blockBelow1);
                    if (golem == null) {
                        return false;
                    }
                    GolemConfigSet cfg = GolemLookup.getConfig(((Object)((Object)golem)).getClass());
                    boolean bl = allowed = cfg != null && cfg.canSpawn();
                    if (!allowed) {
                        return false;
                    }
                    BlockGolemHead.removeAllGolemBlocks(world, pos, flagX);
                    ExtraGolems.LOGGER.info("[Extra Golems]: Building golem " + golem.toString());
                    golem.func_70849_f(true);
                    golem.func_70012_b(x, y, z, 0.0f, 0.0f);
                    world.func_72838_d((Entity)golem);
                    golem.onBuilt(stateBelow1, stateBelow2, arm1, arm2);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isGolemXAligned(World world, BlockPos headPos) {
        BlockPos[] armsX = new BlockPos[]{headPos.func_177979_c(1).func_177985_f(1), headPos.func_177979_c(1).func_177965_g(1)};
        Block below = world.func_180495_p(headPos.func_177979_c(1)).func_177230_c();
        return world.func_180495_p(armsX[0]).func_177230_c() == below && world.func_180495_p(armsX[1]).func_177230_c() == below;
    }

    public static boolean isGolemZAligned(World world, BlockPos headPos) {
        BlockPos[] armsZ = new BlockPos[]{headPos.func_177979_c(1).func_177964_d(1), headPos.func_177979_c(1).func_177970_e(1)};
        Block below = world.func_180495_p(headPos.func_177979_c(1)).func_177230_c();
        return world.func_180495_p(armsZ[0]).func_177230_c() == below && world.func_180495_p(armsZ[1]).func_177230_c() == below;
    }

    public static void removeAllGolemBlocks(World world, BlockPos pos, boolean isXAligned) {
        BlockGolemHead.removeGolemBody(world, pos);
        BlockGolemHead.removeGolemArms(world, pos, isXAligned);
    }

    public static void removeGolemBody(World world, BlockPos head) {
        world.func_175698_g(head);
        world.func_175698_g(head.func_177979_c(1));
        world.func_175698_g(head.func_177979_c(2));
    }

    public static void removeGolemArms(World world, BlockPos pos, boolean isXAligned) {
        if (isXAligned) {
            world.func_175698_g(pos.func_177979_c(1).func_177985_f(1));
            world.func_175698_g(pos.func_177979_c(1).func_177965_g(1));
        } else {
            world.func_175698_g(pos.func_177979_c(1).func_177964_d(1));
            world.func_175698_g(pos.func_177979_c(1).func_177970_e(1));
        }
    }
}

