/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.addon.registry;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.addon.AetherAddonConfig;
import com.gildedgames.the_aether.addon.blocks.BlocksAetherAddon;
import com.gildedgames.the_aether.addon.dictionary.AetherAddonDictionary;
import com.gildedgames.the_aether.addon.items.ItemsAetherAddon;
import com.gildedgames.the_aether.addon.registry.AetherAddonRegistries;
import com.gildedgames.the_aether.api.enchantments.AetherEnchantment;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryModifiable;

public class AetherAddonRegistryEvent {
    private static final ResourceLocation MIMIC_LOOT = Aether.locate((String)"entities/chest_mimic");

    @SubscribeEvent
    public void onRegisterBlockEvent(RegistryEvent.Register<Block> event) {
        BlocksAetherAddon.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public void onRegisterItemEvent(RegistryEvent.Register<Item> event) {
        BlocksAetherAddon.registerItems((IForgeRegistry<Item>)event.getRegistry());
        ItemsAetherAddon.itemRegistry = event.getRegistry();
        ItemsAetherAddon.initialization();
    }

    @SubscribeEvent
    public void onRegisterCraftingEvent(RegistryEvent.Register<IRecipe> event) {
        AetherAddonDictionary.initialization();
        AetherAddonRegistries.initializeRecipes((IForgeRegistryModifiable<IRecipe>)((IForgeRegistryModifiable)event.getRegistry()));
    }

    @SubscribeEvent
    public void onRegisterEnchantmentEvent(RegistryEvent.Register<AetherEnchantment> event) {
        AetherAddonRegistries.initializeEnchantments((IForgeRegistry<AetherEnchantment>)event.getRegistry());
    }

    @SubscribeEvent
    public void onLootTableLoadEvent(LootTableLoadEvent event) {
        if (AetherAddonConfig.enable_skyroot_chest && event.getName().equals((Object)MIMIC_LOOT)) {
            LootTable table = event.getTable();
            LootPool chest = table.getPool("chest");
            if (chest == null) {
                return;
            }
            LootEntry entry = chest.getEntry("minecraft:chest");
            if (entry == null || !(entry instanceof LootEntryItem)) {
                return;
            }
            LootEntryItem item = new LootEntryItem(Item.func_150898_a((Block)BlocksAetherAddon.skyroot_chest), 1, 1, new LootFunction[]{new LootingEnchantBonus(new LootCondition[0], new RandomValueRange(0.0f, 1.0f), 0)}, new LootCondition[0], "aether_legacy:skyroot_chest");
            chest.removeEntry("minecraft:chest");
            chest.addEntry((LootEntry)item);
        }
    }
}

