/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.core;

import cd4017be.dimstack.Main;
import cd4017be.dimstack.api.IDimension;
import cd4017be.dimstack.api.util.SettingProvider;
import cd4017be.dimstack.block.Portal;
import cd4017be.dimstack.core.ChunkLoader;
import cd4017be.dimstack.core.Dimensionstack;
import cd4017be.dimstack.core.LoadingInfo;
import cd4017be.dimstack.worldgen.PortalGen;
import cd4017be.lib.util.DimPos;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashMap;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PortalConfiguration
extends SettingProvider
implements IDimension,
IWorldEventListener {
    public final int dimId;
    private PortalConfiguration neighbourUp;
    private PortalConfiguration neighbourDown;
    public int ceilY = defaultCeilY;
    boolean topOpen = false;
    public boolean flipped = false;
    private int height = Integer.MIN_VALUE;
    ForgeChunkManager.Ticket loadingTicket;
    HashMap<ChunkPos, LoadingInfo> loadedChunks = new HashMap();
    static final Int2ObjectOpenHashMap<PortalConfiguration> dimensions = new Int2ObjectOpenHashMap();
    static int defaultCeilY = 255;
    public static byte retrogen = 0;

    private PortalConfiguration(int dimId) {
        this.dimId = dimId;
    }

    @Override
    public int id() {
        return this.dimId;
    }

    @Override
    public boolean upsideDown() {
        return this.flipped;
    }

    @Override
    public PortalConfiguration up() {
        return this.neighbourUp;
    }

    @Override
    public PortalConfiguration down() {
        return this.neighbourDown;
    }

    @Override
    public PortalConfiguration nextCeil() {
        return this.flipped ? this.neighbourDown : this.neighbourUp;
    }

    @Override
    public PortalConfiguration nextFloor() {
        return this.flipped ? this.neighbourUp : this.neighbourDown;
    }

    @Override
    public PortalConfiguration bottom() {
        PortalConfiguration pc1;
        PortalConfiguration pc = this;
        while ((pc1 = pc.neighbourDown) != null) {
            if (pc1 == this) {
                return null;
            }
            pc = pc1;
        }
        return pc;
    }

    @Override
    public PortalConfiguration top() {
        PortalConfiguration pc1;
        PortalConfiguration pc = this;
        while ((pc1 = pc.neighbourUp) != null) {
            if (pc1 == this) {
                return null;
            }
            pc = pc1;
        }
        return pc;
    }

    @Override
    public int ceilHeight() {
        return this.ceilY;
    }

    @Override
    public int height() {
        if (this.height == Integer.MIN_VALUE) {
            this.computeHeights();
        }
        return this.height;
    }

    private void computeHeights() {
        PortalConfiguration end;
        PortalConfiguration pc = this.bottom();
        if (pc == null) {
            pc = this.neighbourUp;
            end = this;
        } else {
            end = null;
        }
        int base = this.dimId;
        int abs = Math.abs(this.dimId);
        while (pc != end) {
            int d = pc.dimId;
            int a = Math.abs(d);
            if (a < abs || a == abs && d < base) {
                abs = a;
                base = d;
            }
            pc = pc.neighbourUp;
        }
        pc = PortalConfiguration.get(base);
        int h = 0;
        while (pc != null) {
            if (h > 0 && pc.dimId == base) {
                return;
            }
            pc.height = h++;
            pc = pc.neighbourUp;
        }
        pc = PortalConfiguration.get((int)base).neighbourDown;
        h = -1;
        while (pc != null) {
            pc.height = h--;
            pc = pc.neighbourDown;
        }
    }

    public void unlink() {
        PortalConfiguration u = this.neighbourUp;
        PortalConfiguration d = this.neighbourDown;
        if (u != null) {
            u.neighbourDown = d;
        }
        if (d != null) {
            d.neighbourUp = u;
        }
        this.neighbourUp = null;
        this.neighbourDown = null;
    }

    @Override
    public void insertTop(IDimension dim) {
        if (dim == this.neighbourUp) {
            return;
        }
        PortalConfiguration pc = (PortalConfiguration)dim;
        if (this.neighbourUp != null) {
            pc.unlink();
            PortalConfiguration u = this.neighbourUp;
            if (u != null) {
                pc.neighbourUp = u;
                u.neighbourDown = pc;
            }
        } else {
            pc.splitBottom();
        }
        this.neighbourUp = pc;
        pc.neighbourDown = this;
    }

    @Override
    public void insertBottom(IDimension dim) {
        if (dim == this.neighbourDown) {
            return;
        }
        PortalConfiguration pc = (PortalConfiguration)dim;
        if (this.neighbourDown != null) {
            pc.unlink();
            PortalConfiguration d = this.neighbourDown;
            if (d != null) {
                pc.neighbourDown = d;
                d.neighbourUp = pc;
            }
        } else {
            pc.splitTop();
        }
        this.neighbourDown = pc;
        pc.neighbourUp = this;
    }

    public void splitTop() {
        PortalConfiguration p = this.neighbourUp;
        if (p != null) {
            p.neighbourDown = null;
            this.neighbourUp = null;
        }
    }

    public void splitBottom() {
        PortalConfiguration p = this.neighbourDown;
        if (p != null) {
            p.neighbourUp = null;
            this.neighbourDown = null;
        }
    }

    @Override
    public WorldServer getWorld() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dimId);
    }

    void unforceLeastRelevantChunks(int n) {
        if (n < 0) {
            n = 0;
        }
        while (this.loadedChunks.size() > n) {
            long t = System.currentTimeMillis();
            float p = 1.0f;
            ChunkPos last = null;
            for (LoadingInfo li : this.loadedChunks.values()) {
                float f = li.stillNeeded(t);
                if (!(f < p)) continue;
                p = f;
                last = li.chunk;
            }
            this.loadedChunks.remove(last);
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loadingTicket, last);
        }
    }

    public String toString() {
        String name;
        try {
            name = DimensionManager.getProviderType((int)this.dimId).func_186065_b();
        }
        catch (IllegalArgumentException e) {
            name = "\u00a7oundefined\u00a7r";
        }
        return "id " + Integer.toString(this.dimId) + ": " + name;
    }

    public void setTopOpen() {
        if (this.topOpen || this.nextCeil() == null) {
            return;
        }
        this.topOpen = true;
        Dimensionstack.markDirty();
    }

    public void func_184376_a(World world, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        IBlockState stateP;
        BlockPos posP;
        PortalConfiguration neigb;
        if ((flags & 1) == 0) {
            return;
        }
        int y = pos.func_177956_o();
        int yc = this.ceilY;
        if (y <= 4 && retrogen > 0 && oldState.func_185904_a() == Material.field_151579_a ^ newState.func_185904_a() == Material.field_151579_a && (neigb = this.nextFloor()) != null) {
            PortalGen.fixCeil(world, pos, 0, neigb, this.flipped ^ neigb.flipped ? 0 : neigb.ceilY);
        }
        if (y >= yc - 4 && (retrogen > 0 ? oldState.func_185904_a() == Material.field_151579_a ^ newState.func_185904_a() == Material.field_151579_a : this.topOpen && oldState.func_185904_a() == Material.field_151579_a && newState.func_185904_a() != Material.field_151579_a) && (neigb = this.nextCeil()) != null) {
            PortalGen.fixCeil(world, pos, yc, neigb, this.flipped ^ neigb.flipped ? neigb.ceilY : 0);
        }
        if (y == 2) {
            posP = pos.func_177979_c(2);
            IBlockState stateP2 = world.func_180495_p(posP);
            if (stateP2.func_177230_c() instanceof Portal) {
                stateP2.func_189546_a(world, posP, newState.func_177230_c(), pos);
            }
        } else if (y == yc - 2 && (stateP = world.func_180495_p(posP = pos.func_177981_b(2))).func_177230_c() instanceof Portal) {
            stateP.func_189546_a(world, posP, newState.func_177230_c(), pos);
        }
    }

    public void func_174959_b(BlockPos pos) {
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_184375_a(EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_190570_a(int id, boolean ignoreRange, boolean p_190570_3_, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
    }

    public static PortalConfiguration get(World world) {
        return PortalConfiguration.get(world.field_73011_w.getDimension());
    }

    public static PortalConfiguration get(int dimId) {
        PortalConfiguration pc = (PortalConfiguration)dimensions.get(dimId);
        if (pc == null) {
            pc = new PortalConfiguration(dimId);
            dimensions.put(dimId, (Object)pc);
        }
        return pc;
    }

    public static void link(int ... dims) {
        if (dims.length < 2) {
            return;
        }
        PortalConfiguration A = PortalConfiguration.get(dims[0]);
        for (int i = 1; i < dims.length; ++i) {
            PortalConfiguration B = PortalConfiguration.get(dims[i]);
            if (A.neighbourUp != null) {
                A.neighbourUp.neighbourDown = null;
            }
            if (B.neighbourDown != null) {
                B.neighbourDown.neighbourUp = null;
            }
            A.neighbourUp = B;
            B.neighbourDown = A;
            A = B;
        }
    }

    public static DimPos getAdjacentPos(DimPos pos) {
        return PortalConfiguration.getAdjacentPos(pos, true);
    }

    public static DimPos getAdjacentPos(DimPos pos, boolean forceLoad) {
        PortalConfiguration pc1;
        PortalConfiguration pc0 = PortalConfiguration.get(pos.dimId);
        int y = pos.func_177956_o();
        if (y == 0) {
            pc1 = pc0.nextFloor();
            if (pc1 == null) {
                return null;
            }
            y = pc1.ceilY;
        } else if (y == pc0.ceilY) {
            pc1 = pc0.nextCeil();
            if (pc1 == null) {
                return null;
            }
            y = 0;
        } else {
            return null;
        }
        if (pc0.flipped ^ pc1.flipped) {
            y = pc1.ceilY - y;
        }
        WorldServer world = pos.getWorldServer();
        if (pc1 != pc0) {
            int d = pc1.dimId;
            world = DimensionManager.getWorld((int)d);
            if (!(forceLoad || world != null && world.func_175667_e((BlockPos)pos))) {
                return null;
            }
            if (world == null) {
                DimensionManager.initDimension((int)d);
                world = DimensionManager.getWorld((int)d);
                if (world == null) {
                    return null;
                }
            }
            if (ChunkLoader.active()) {
                ChunkPos chunk = new ChunkPos((BlockPos)pos);
                LoadingInfo ti = pc1.loadedChunks.get(chunk);
                if (ti != null) {
                    ti.onRequest((BlockPos)pos);
                } else {
                    WorldServer world1 = pc1.getWorld();
                    if (pc1.loadingTicket == null || pc1.loadingTicket.world != world1) {
                        pc1.loadingTicket = ForgeChunkManager.requestTicket((Object)Main.instance, (World)world1, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                    }
                    if (pc1.loadingTicket != null) {
                        pc1.loadedChunks.put(chunk, new LoadingInfo(pc1, (BlockPos)pos));
                    }
                }
            }
        }
        return new DimPos(pos.func_177958_n(), y, pos.func_177952_p(), world);
    }

    public static IntSet getDefinedIds() {
        return dimensions.keySet();
    }
}

