/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.command;

import cd4017be.dimstack.util.ChunkIterator;
import cd4017be.lib.TickRegistry;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class Regen
extends CommandBase
implements TickRegistry.ITickReceiver {
    public static final HashMap<String, IWorldGenerator> generators = new HashMap();
    IWorldGenerator[] gens;
    ICommandSender sender;
    LongIterator chunks;
    int dim;
    int processed;
    int total;
    long t;

    public String func_71517_b() {
        return "ds_regen";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.ds_regen.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        int i = 1;
        switch (args.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Regen.func_71530_a((String[])args, (String[])new String[]{"help", "cancel", "~"});
            }
            case 2: {
                List list = Regen.func_71530_a((String[])args, (String[])new String[]{"loaded"});
                list.addAll(Regen.func_181043_b((String[])args, (int)i, (BlockPos)targetPos));
                return list;
            }
            case 4: 
            case 5: {
                i = 3;
            }
            case 3: {
                if (args[1].equals("loaded")) break;
                return Regen.func_181043_b((String[])args, (int)i, (BlockPos)targetPos);
            }
        }
        return Regen.func_175762_a((String[])args, generators.keySet());
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            throw new WrongUsageException("commands.ds_regen.usage", new Object[0]);
        }
        String s = args[0];
        if (s.equals("help")) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ds_regen.info", new Object[]{generators.keySet()}));
            return;
        }
        if (s.equals("cancel")) {
            this.chunks = null;
            this.gens = null;
            return;
        }
        if (args.length < 3) {
            throw new WrongUsageException("commands.blockrepl.usage", new Object[0]);
        }
        if (this.sender != null || this.chunks != null) {
            throw new CommandException("commands.ds_regen.running", new Object[0]);
        }
        Object world = s.equals("~") ? sender.func_130014_f_() : server.func_71218_a(Regen.func_175755_a((String)s));
        if (world == null) {
            throw new CommandException("commands.ds_regen.invalid_dim", new Object[0]);
        }
        int i = 1;
        if (args[i].equals("loaded")) {
            ++i;
            long[] a = ((WorldServer)world).func_72863_F().field_73244_f.keySet().toLongArray();
            this.total = a.length;
            this.chunks = LongIterators.wrap((long[])a);
        } else {
            if (args.length < 6) {
                throw new WrongUsageException("commands.blockrepl.usage", new Object[0]);
            }
            BlockPos pos = sender.func_180425_c();
            this.chunks = new ChunkIterator((int)Regen.func_175761_b((double)pos.func_177958_n(), (String)args[i++], (boolean)false) >> 4, (int)Regen.func_175761_b((double)pos.func_177952_p(), (String)args[i++], (boolean)false) >> 4, (int)Regen.func_175761_b((double)pos.func_177958_n(), (String)args[i++], (boolean)false) + 15 >> 4, (int)Regen.func_175761_b((double)pos.func_177952_p(), (String)args[i++], (boolean)false) + 15 >> 4);
            this.total = ((ChunkIterator)this.chunks).size();
            if (this.total < 0) {
                this.total = 0;
            }
        }
        this.gens = new IWorldGenerator[args.length - i];
        int j = 0;
        while (i < args.length) {
            this.gens[j] = generators.get(args[i]);
            if (this.gens[j] == null) {
                this.chunks = null;
                this.gens = null;
                throw new CommandException("commands.ds_regen.invalid_gen", new Object[]{s});
            }
            ++i;
            ++j;
        }
        this.sender = sender;
        this.processed = 0;
        this.dim = world.field_73011_w.getDimension();
        TickRegistry.instance.add((TickRegistry.ITickReceiver)this);
    }

    public boolean tick() {
        if (this.sender == null) {
            return false;
        }
        if (this.chunks == null) {
            this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ds_regen.cancel", new Object[]{this.processed, this.total}));
            this.sender = null;
            this.gens = null;
            return false;
        }
        long t = System.currentTimeMillis();
        if (t - this.t > 1000L) {
            this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ds_regen.progress", new Object[]{this.processed, this.total, this.total == 0 ? 100 : this.processed * 100 / this.total}));
            this.t = t;
        }
        WorldServer world = this.sender.func_184102_h().func_71218_a(this.dim);
        IChunkProvider provider = world.func_72863_F();
        long worldSeed = world.func_72905_C();
        Random rand = new Random(worldSeed);
        long xSeed = rand.nextLong() >> 3;
        long zSeed = rand.nextLong() >> 3;
        do {
            int z;
            if (!this.chunks.hasNext()) {
                this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ds_regen.complete", new Object[0]));
                this.sender = null;
                this.chunks = null;
                this.gens = null;
                return false;
            }
            ++this.processed;
            long p = this.chunks.nextLong();
            int x = (int)p;
            if (!provider.func_191062_e(x, z = (int)(p >> 32))) continue;
            long chunkSeed = xSeed * (long)x + zSeed * (long)z ^ worldSeed;
            for (IWorldGenerator gen : this.gens) {
                rand.setSeed(chunkSeed);
                gen.generate(rand, x, z, (World)world, null, provider);
            }
        } while (System.currentTimeMillis() - t < 50L);
        return true;
    }
}

