/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.asm;

import cd4017be.dimstack.asm.CorePlugin;
import cd4017be.dimstack.asm.Name;
import java.util.Arrays;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class BlockPortalTransformer
implements IClassTransformer {
    final String c_World = Name.type("net.minecraft.world.World");
    final String c_BlockPos = Name.type("net.minecraft.util.math.BlockPos");
    final String c_BlockPortal = Name.type("net.minecraft.block.BlockPortal");
    final String n_BlockPortal = Name.name(this.c_BlockPortal);
    final String m_trySpawnPortal = Name.method("trySpawnPortal", "func_176548_d");
    final String md_trySpawnPortal = Name.m_desc(Character.valueOf('Z'), this.c_World, this.c_BlockPos);
    final String c_DisabledPortals = Name.type("cd4017be.dimstack.api.DisabledPortals");
    final String m_allowNetherPortal;
    final String md_allowNetherPortal = Name.m_desc(Character.valueOf('Z'), "net.minecraft.world.World");

    public BlockPortalTransformer() {
        this.m_allowNetherPortal = "allowNetherPortal";
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals(this.n_BlockPortal)) {
            return this.transformBP(basicClass);
        }
        return basicClass;
    }

    private byte[] transformBP(byte[] data) {
        ClassNode cn = new ClassNode();
        ClassReader cr = new ClassReader(data);
        cr.accept((ClassVisitor)cn, 0);
        CorePlugin.LOG.debug("patching BlockPortal as {} ...", (Object)cn.name);
        boolean found = false;
        for (MethodNode mn : cn.methods) {
            if (!mn.desc.equals(this.md_trySpawnPortal) || !mn.name.equals(this.m_trySpawnPortal)) continue;
            CorePlugin.LOG.debug("patching method trySpawnPortal() as {}{}", (Object)mn.name, (Object)mn.desc);
            InsnList inj = new InsnList();
            LabelNode end = new LabelNode();
            inj.add((AbstractInsnNode)new VarInsnNode(25, 1));
            inj.add((AbstractInsnNode)new MethodInsnNode(184, this.c_DisabledPortals, this.m_allowNetherPortal, this.md_allowNetherPortal, false));
            inj.add((AbstractInsnNode)new JumpInsnNode(154, end));
            inj.add((AbstractInsnNode)new InsnNode(3));
            inj.add((AbstractInsnNode)new InsnNode(172));
            inj.add((AbstractInsnNode)end);
            inj.add((AbstractInsnNode)new FrameNode(3, 3, new Object[]{this.c_BlockPortal, this.c_World, this.c_BlockPos}, 0, new Object[0]));
            mn.instructions.insert(inj);
            found = true;
        }
        if (!found) {
            Object[] names = new String[cn.methods.size()];
            for (int i = 0; i < names.length; ++i) {
                MethodNode mn = (MethodNode)cn.methods.get(i);
                names[i] = mn.name + mn.desc;
            }
            CorePlugin.LOG.error("can't find BlockPortal.trySpawnPortal() in {}", (Object)Arrays.toString(names));
            CorePlugin.LOG.info("method name = {}, descriptor = {}", (Object)this.m_trySpawnPortal, (Object)this.md_trySpawnPortal);
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }
}

