/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.util;

import betterwithaddons.item.ItemTeaCup;
import betterwithaddons.item.ModItems;
import betterwithaddons.util.NabeResult;
import betterwithaddons.util.StackResult;
import java.awt.Color;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class NabeResultPoison
extends NabeResult {
    int doses;
    int maxDoses;

    public NabeResultPoison() {
        super(new ResourceLocation("betterwithaddons", "blocks/nabe_liquid"), new Color(50, 100, 50).getRGB());
    }

    public NabeResultPoison(int doses, int maxDoses) {
        super(new ResourceLocation("betterwithaddons", "blocks/nabe_liquid"), new Color(50, 100, 50).getRGB());
        this.doses = doses;
        this.maxDoses = maxDoses;
    }

    @Override
    public float getFillRatio() {
        return (float)this.doses / (float)this.maxDoses;
    }

    @Override
    public boolean isFull() {
        return this.doses >= this.maxDoses;
    }

    @Override
    public StackResult take(ItemStack container) {
        if (this.doses >= 1 && container.func_77973_b() == ModItems.YA) {
            int consumed = Math.min(container.func_190916_E(), this.doses);
            this.doses -= consumed;
            container.func_190918_g(consumed);
            return new StackResult(true, container, new ItemStack((Item)ModItems.YA_POISONED, consumed));
        }
        if (this.doses >= 4 && container.func_77973_b() == ModItems.TEA_CUP && !ItemTeaCup.isFilled(container)) {
            container.func_190918_g(1);
            this.doses -= 4;
            return new StackResult(true, container, ModItems.TEA_CUP.getFilled(this));
        }
        return new StackResult(false, container);
    }

    @Override
    public NabeResult copy() {
        return new NabeResultPoison(this.doses, this.maxDoses);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("doses", this.doses);
        compound.func_74768_a("maxDoses", this.maxDoses);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.doses = compound.func_74762_e("doses");
        this.maxDoses = compound.func_74762_e("maxDoses");
    }
}

